/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.server;

import com.google.inject.Inject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import net.minecraft.crash.CrashReport;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.Packet;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ITickable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.server.SpongeVanilla;

@Mixin(value={MinecraftServer.class}, priority=999)
public abstract class MixinMinecraftServer
implements IMixinMinecraftServer {
    @Inject
    private static SpongeVanilla spongeVanilla;
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    @Final
    private List<ITickable> field_71322_p;
    @Shadow
    @Final
    public Profiler field_71304_b;
    @Shadow
    private PlayerList field_71318_t;
    @Shadow
    private int field_71315_w;
    @Shadow
    @Final
    protected Queue<FutureTask<?>> field_175589_i;
    private boolean skipServerStop;
    private final Int2ObjectMap<long[]> worldTickTimes = new Int2ObjectOpenHashMap(3);

    @Shadow
    public abstract boolean func_71255_r();

    @Shadow
    public abstract NetworkSystem func_147137_ag();

    @Overwrite
    public String getServerModName() {
        return spongeVanilla.getName();
    }

    @Overwrite
    public void func_145747_a(ITextComponent component) {
        field_147145_h.info(SpongeTexts.toLegacy(component));
    }

    @org.spongepowered.asm.mixin.injection.Inject(method={"stopServer()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventDoubleStop(CallbackInfo ci) {
        if (this.skipServerStop) {
            ci.cancel();
        } else {
            this.skipServerStop = true;
        }
    }

    @org.spongepowered.asm.mixin.injection.Inject(method={"stopServer"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;)V", ordinal=0, shift=At.Shift.AFTER, remap=false)})
    private void callServerStopping(CallbackInfo ci) {
        spongeVanilla.onServerStopping();
    }

    @org.spongepowered.asm.mixin.injection.Inject(method={"applyServerIconToResponse"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddFaviconToStatusResponse(ServerStatusResponse response, CallbackInfo ci) {
        if (response.func_151316_d() != null) {
            ci.cancel();
        }
    }

    @Override
    public long[] getWorldTickTimes(int dimensionId) {
        return (long[])this.worldTickTimes.get(dimensionId);
    }

    @Override
    public void putWorldTickTimes(int dimensionId, long[] tickTimes) {
        this.worldTickTimes.put(dimensionId, (Object)tickTimes);
    }

    @Override
    public void removeWorldTickTimes(int dimensionId) {
        this.worldTickTimes.remove(dimensionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_71190_q() {
        this.field_71304_b.func_76320_a("jobs");
        Queue<FutureTask<?>> queue = this.field_175589_i;
        synchronized (queue) {
            while (!this.field_175589_i.isEmpty()) {
                Util.func_181617_a(this.field_175589_i.poll(), (Logger)field_147145_h);
            }
        }
        this.field_71304_b.func_76318_c("levels");
        this.tickChunkLoader();
        ObjectIterator<Int2ObjectMap.Entry<WorldServer>> it = WorldManager.worldsIterator();
        while (it.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)it.next();
            WorldServer worldServer = (WorldServer)entry.getValue();
            long i = System.nanoTime();
            if (entry.getIntKey() == 0 || this.func_71255_r()) {
                IMixinWorldServer spongeWorld = (IMixinWorldServer)worldServer;
                if (spongeWorld.getChunkGCTickInterval() > 0) {
                    spongeWorld.doChunkGC();
                }
                this.field_71304_b.func_76320_a(worldServer.func_72912_H().func_76065_j());
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_148537_a((Packet)new SPacketTimeUpdate(worldServer.func_82737_E(), worldServer.func_72820_D(), worldServer.func_82736_K().func_82766_b("doDaylightCycle")), ((IMixinWorldServer)worldServer).getDimensionId().intValue());
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                try {
                    worldServer.func_72835_b();
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Exception ticking world");
                    worldServer.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                try {
                    worldServer.func_72939_s();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception ticking world entities");
                    worldServer.func_72914_a(crashreport1);
                    throw new ReportedException(crashreport1);
                }
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76320_a("tracker");
                if (spongeWorld.getChunkGCTickInterval() > 0) {
                    worldServer.func_72863_F().func_73156_b();
                }
                worldServer.func_73039_n().func_72788_a();
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            ((long[])this.worldTickTimes.get((int)entry.getIntKey()))[this.field_71315_w % 100] = System.nanoTime() - i;
        }
        this.field_71304_b.func_76318_c("dim_unloading");
        WorldManager.unloadQueuedWorlds();
        this.field_71304_b.func_76318_c("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_76318_c("players");
        this.field_71318_t.func_72374_b();
        this.field_71304_b.func_76318_c("tickables");
        for (int k = 0; k < this.field_71322_p.size(); ++k) {
            this.field_71322_p.get(k).func_73660_a();
        }
        this.field_71304_b.func_76319_b();
    }

    @Redirect(method={"stopServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;flush()V"))
    private void onFlushWorld(WorldServer world) {
        world.func_73041_k();
        Sponge.getCauseStackManager().pushCause(this);
        SpongeImpl.postEvent(SpongeEventFactory.createUnloadWorldEvent(Sponge.getCauseStackManager().getCurrentCause(), (World)world));
        Sponge.getCauseStackManager().popCause();
    }

    private void tickChunkLoader() {
    }
}

