/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import co.aikar.timings.SpongeTimings;
import co.aikar.timings.Timing;
import com.google.common.base.MoreObjects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;

public class ScheduledTask
implements Task {
    final long offset;
    final long period;
    final boolean delayIsTicks;
    final boolean intervalIsTicks;
    private final PluginContainer owner;
    private final Consumer<Task> consumer;
    private long timestamp;
    private ScheduledTaskState state;
    private final UUID id;
    private final String name;
    private final TaskSynchronicity syncType;
    private final String stringRepresentation;
    private Timing taskTimer;

    ScheduledTask(TaskSynchronicity syncType, Consumer<Task> task, String taskName, long delay, boolean delayIsTicks, long interval, boolean intervalIsTicks, PluginContainer pluginContainer) {
        this.setState(ScheduledTaskState.WAITING);
        this.offset = delay;
        this.delayIsTicks = delayIsTicks;
        this.period = interval;
        this.intervalIsTicks = intervalIsTicks;
        this.owner = pluginContainer;
        this.consumer = task;
        this.id = UUID.randomUUID();
        this.name = taskName;
        this.syncType = syncType;
        this.stringRepresentation = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("delay", this.offset).add("interval", this.period).add("owner", (Object)this.owner).add("id", (Object)this.id).add("isAsync", this.isAsynchronous()).toString();
    }

    @Override
    public PluginContainer getOwner() {
        return this.owner;
    }

    @Override
    public long getDelay() {
        if (this.delayIsTicks) {
            return this.offset;
        }
        return TimeUnit.NANOSECONDS.toMillis(this.offset);
    }

    @Override
    public long getInterval() {
        if (this.intervalIsTicks) {
            return this.period;
        }
        return TimeUnit.NANOSECONDS.toMillis(this.period);
    }

    @Override
    public boolean cancel() {
        boolean success = false;
        if (this.getState() != ScheduledTaskState.RUNNING) {
            success = true;
        }
        this.setState(ScheduledTaskState.CANCELED);
        return success;
    }

    @Override
    public Consumer<Task> getConsumer() {
        return this.consumer;
    }

    @Override
    public UUID getUniqueId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAsynchronous() {
        return this.syncType == TaskSynchronicity.ASYNCHRONOUS;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    long nextExecutionTimestamp() {
        if (this.state.isActive) {
            return this.timestamp + this.period;
        }
        return this.timestamp + this.offset;
    }

    void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    ScheduledTaskState getState() {
        return this.state;
    }

    void setState(ScheduledTaskState state) {
        this.state = state;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public Timing getTimingsHandler() {
        if (this.taskTimer == null) {
            this.taskTimer = SpongeTimings.getPluginSchedulerTimings(this.owner);
        }
        return this.taskTimer;
    }

    public static enum TaskSynchronicity {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }

    public static enum ScheduledTaskState {
        WAITING(false),
        SWITCHING(true),
        RUNNING(true),
        CANCELED(false);

        public final boolean isActive;

        private ScheduledTaskState(boolean active) {
            this.isActive = active;
        }
    }
}

