/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import com.flowpowered.math.vector.Vector3d;
import java.lang.ref.WeakReference;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.living.humanoid.AnimateHandEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public class PacketUtil {
    private static final PhaseContext<?> EMPTY = new BasicPacketContext((PacketState)PacketPhase.General.INVALID).markEmpty();
    private static long lastInventoryOpenPacketTimeStamp = 0L;
    private static long lastTryBlockPacketTimeStamp = 0L;
    private static boolean lastTryBlockPacketItemResult = true;

    public static void onProcessPacket(Packet packetIn, INetHandler netHandler) {
        if (netHandler instanceof NetHandlerPlayServer) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                long packetDiff;
                EntityPlayerMP packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
                Sponge.getCauseStackManager().pushCause(packetPlayer);
                if (PacketUtil.firePreEvents(packetIn, packetPlayer)) {
                    return;
                }
                boolean ignoreCreative = false;
                if (PacketUtil.creativeCheck(packetIn, packetPlayer) && (packetDiff = System.currentTimeMillis() - lastInventoryOpenPacketTimeStamp) < 100L) {
                    ignoreCreative = true;
                }
                boolean ignoreMovementCapture = false;
                if (packetIn instanceof CPacketPlayer) {
                    CPacketPlayer movingPacket = (CPacketPlayer)packetIn;
                    if (movingPacket instanceof CPacketPlayer.Rotation) {
                        ignoreMovementCapture = true;
                    } else if (packetPlayer.field_70165_t == movingPacket.field_149479_a && packetPlayer.field_70163_u == movingPacket.field_149477_b && packetPlayer.field_70161_v == movingPacket.field_149478_c) {
                        ignoreMovementCapture = true;
                    }
                }
                if (ignoreMovementCapture || packetIn instanceof CPacketClientSettings) {
                    packetIn.func_148833_a(netHandler);
                }
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(packetPlayer.field_71071_by.func_70445_o());
                PhaseTracker phaseTracker = PhaseTracker.getInstance();
                IPhaseState<PacketContext<?>> packetState = TrackingPhases.PACKET.getStateForPacket(packetIn);
                if (packetState == null) {
                    throw new IllegalArgumentException("Found a null packet phase for packet: " + packetIn.getClass());
                }
                PhaseContext<Object> context = EMPTY;
                if (!TrackingPhases.PACKET.isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    context = ((PacketContext)((PacketContext)((PacketContext)((PacketContext)packetState.createPhaseContext().source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn)).cursor(cursor)).ignoreCreative(ignoreCreative);
                    TrackingPhases.PACKET.populateContext(packetIn, packetPlayer, packetState, context);
                    context.owner((Player)packetPlayer);
                    context.notifier((Player)packetPlayer);
                }
                try (Object packetContext = context.buildAndSwitch();){
                    packetIn.func_148833_a(netHandler);
                }
                if (packetIn instanceof CPacketClientStatus) {
                    packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
                }
                ((IMixinEntityPlayerMP)packetPlayer).setPacketItem(ItemStack.field_190927_a);
            }
        } else {
            packetIn.func_148833_a(netHandler);
        }
    }

    private static boolean creativeCheck(Packet<?> packetIn, EntityPlayerMP playerMP) {
        return packetIn instanceof CPacketCreativeInventoryAction;
    }

    private static boolean firePreEvents(Packet<?> packetIn, EntityPlayerMP playerMP) {
        if (packetIn instanceof CPacketAnimation) {
            CPacketAnimation packet = (CPacketAnimation)packetIn;
            SpongeCommonEventFactory.lastAnimationPacketTick = SpongeImpl.getServer().func_71259_af();
            SpongeCommonEventFactory.lastAnimationPlayer = new WeakReference<EntityPlayerMP>(playerMP);
            HandType handType = packet.func_187018_a() == EnumHand.MAIN_HAND ? HandTypes.MAIN_HAND : HandTypes.OFF_HAND;
            ItemStack heldItem = playerMP.func_184586_b(packet.func_187018_a());
            Sponge.getCauseStackManager().addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
            AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(Sponge.getCauseStackManager().getCurrentCause(), handType, (Humanoid)playerMP);
            return SpongeImpl.postEvent(event);
        }
        if (packetIn instanceof CPacketPlayerDigging) {
            SpongeCommonEventFactory.lastPrimaryPacketTick = SpongeImpl.getServer().func_71259_af();
            CPacketPlayerDigging packet = (CPacketPlayerDigging)packetIn;
            ItemStack stack = playerMP.func_184614_ca();
            Sponge.getCauseStackManager().addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
            switch (packet.func_180762_c()) {
                case DROP_ITEM: 
                case DROP_ALL_ITEMS: {
                    if (!stack.func_190926_b() && !playerMP.func_175149_v()) {
                        ((IMixinEntityPlayerMP)playerMP).setPacketItem(stack.func_77946_l());
                    }
                    return false;
                }
                case START_DESTROY_BLOCK: 
                case ABORT_DESTROY_BLOCK: 
                case STOP_DESTROY_BLOCK: {
                    BlockPos pos = packet.func_179715_a();
                    Vector3d interactionPoint = VecHelper.toVector3d(pos);
                    BlockSnapshot blockSnapshot = new Location<World>((World)playerMP.field_70170_p, interactionPoint).createSnapshot();
                    RayTraceResult result = SpongeImplHooks.rayTraceEyes((EntityLivingBase)playerMP, SpongeImplHooks.getBlockReachDistance(playerMP));
                    if (SpongeCommonEventFactory.callInteractItemEventPrimary((EntityPlayer)playerMP, stack, EnumHand.MAIN_HAND, result == null ? null : VecHelper.toVector3d(result.field_72307_f), blockSnapshot).isCancelled()) {
                        ((IMixinEntityPlayerMP)playerMP).sendBlockChange(pos, playerMP.field_70170_p.func_180495_p(pos));
                        return true;
                    }
                    double d0 = playerMP.field_70165_t - ((double)pos.func_177958_n() + 0.5);
                    double d1 = playerMP.field_70163_u - ((double)pos.func_177956_o() + 0.5) + 1.5;
                    double d2 = playerMP.field_70161_v - ((double)pos.func_177952_p() + 0.5);
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    double dist = SpongeImplHooks.getBlockReachDistance(playerMP) + 1.0;
                    if (d3 > (dist *= dist)) {
                        return true;
                    }
                    if (pos.func_177956_o() >= SpongeImpl.getServer().func_71207_Z()) {
                        return true;
                    }
                    if (packet.func_180762_c() == CPacketPlayerDigging.Action.START_DESTROY_BLOCK && SpongeCommonEventFactory.callInteractBlockEventPrimary((EntityPlayer)playerMP, blockSnapshot, EnumHand.MAIN_HAND, packet.func_179714_b(), result == null ? null : VecHelper.toVector3d(result.field_72307_f)).isCancelled()) {
                        ((IMixinEntityPlayerMP)playerMP).sendBlockChange(pos, playerMP.field_70170_p.func_180495_p(pos));
                        return true;
                    }
                    return false;
                }
            }
        } else if (packetIn instanceof CPacketPlayerTryUseItem) {
            CPacketPlayerTryUseItem packet = (CPacketPlayerTryUseItem)packetIn;
            SpongeCommonEventFactory.lastSecondaryPacketTick = SpongeImpl.getServer().func_71259_af();
            long packetDiff = System.currentTimeMillis() - lastTryBlockPacketTimeStamp;
            if (packetDiff < 100L) {
                return lastTryBlockPacketItemResult;
            }
            ItemStack heldItem = playerMP.func_184586_b(packet.func_187028_a());
            Sponge.getCauseStackManager().addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
            RayTraceResult result = SpongeImplHooks.rayTraceEyes((EntityLivingBase)playerMP, SpongeImplHooks.getBlockReachDistance(playerMP));
            boolean isCancelled = SpongeCommonEventFactory.callInteractItemEventSecondary((EntityPlayer)playerMP, heldItem, packet.func_187028_a(), result == null ? null : VecHelper.toVector3d(result.field_72307_f), BlockSnapshot.NONE).isCancelled();
            SpongeCommonEventFactory.callInteractBlockEventSecondary((EntityPlayer)playerMP, heldItem, result == null ? null : VecHelper.toVector3d(result.field_72307_f), BlockSnapshot.NONE, Direction.NONE, packet.func_187028_a());
            if (isCancelled) {
                playerMP.func_71110_a(playerMP.field_71070_bA, playerMP.field_71070_bA.func_75138_a());
                return true;
            }
        } else if (packetIn instanceof CPacketPlayerTryUseItemOnBlock) {
            boolean isCancelled;
            CPacketPlayerTryUseItemOnBlock packet = (CPacketPlayerTryUseItemOnBlock)packetIn;
            lastTryBlockPacketTimeStamp = System.currentTimeMillis();
            SpongeCommonEventFactory.lastSecondaryPacketTick = SpongeImpl.getServer().func_71259_af();
            Vector3d interactionPoint = VecHelper.toVector3d(packet.func_187023_a());
            RayTraceResult result = SpongeImplHooks.rayTraceEyes((EntityLivingBase)playerMP, SpongeImplHooks.getBlockReachDistance(playerMP));
            BlockSnapshot blockSnapshot = new Location<World>((World)playerMP.field_70170_p, interactionPoint).createSnapshot();
            ItemStack heldItem = playerMP.func_184586_b(packet.func_187022_c());
            Sponge.getCauseStackManager().addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
            lastTryBlockPacketItemResult = isCancelled = SpongeCommonEventFactory.callInteractItemEventSecondary((EntityPlayer)playerMP, heldItem, packet.func_187022_c(), result == null ? null : VecHelper.toVector3d(result.field_72307_f), blockSnapshot).isCancelled();
            if (isCancelled) {
                BlockPos pos = packet.func_187023_a();
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(playerMP.field_70170_p, pos));
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(playerMP.field_70170_p, pos.func_177972_a(packet.func_187024_b())));
                playerMP.func_71110_a(playerMP.field_71070_bA, playerMP.field_71070_bA.func_75138_a());
                return true;
            }
        }
        return false;
    }
}

