/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.world;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;

@Mixin(value={Chunk.class}, priority=1002)
public abstract class MixinChunk_Async_Lighting
implements IMixinChunk {
    private CopyOnWriteArrayList<Short> queuedSkyLightingUpdates = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<Short> queuedBlockLightingUpdates = new CopyOnWriteArrayList();
    private AtomicInteger pendingLightUpdates = new AtomicInteger();
    private long lightUpdateTime;
    private ExecutorService lightExecutorService;
    private static final List<Chunk> EMPTY_LIST = new ArrayList<Chunk>();
    private static final BlockPos DUMMY_POS = new BlockPos(0, 0, 0);
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    private int[] field_76634_f;
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    private boolean field_76646_k;
    @Shadow
    private boolean field_150814_l;
    @Shadow
    private boolean field_150815_m;
    @Shadow
    private boolean field_76643_l;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private boolean[] field_76639_c;
    @Shadow
    private boolean field_76650_s;
    @Shadow
    private int field_82912_p;
    @Shadow
    private ConcurrentLinkedQueue<BlockPos> field_177447_w;

    @Shadow
    public abstract void func_150809_p();

    @Shadow
    public abstract void func_180700_a(EnumFacing var1);

    @Shadow
    public abstract int func_76625_h();

    @Shadow
    protected abstract void func_150803_c(boolean var1);

    @Shadow
    public abstract int func_76611_b(int var1, int var2);

    @Shadow
    protected abstract void func_76599_g(int var1, int var2, int var3);

    @Shadow
    public abstract TileEntity func_177424_a(BlockPos var1, Chunk.EnumCreateEntityType var2);

    @Shadow
    public abstract TileEntity func_177422_i(BlockPos var1);

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);

    @Shadow
    public abstract void func_177441_y();

    @Shadow
    public abstract int func_150808_b(int var1, int var2, int var3);

    @Shadow
    public abstract void func_76609_d(int var1, int var2, int var3, int var4);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onConstruct(World worldIn, int x, int z, CallbackInfo ci) {
        if (!worldIn.field_72995_K) {
            this.lightExecutorService = ((IMixinWorldServer)worldIn).getLightingExecutor();
        }
    }

    @Override
    public AtomicInteger getPendingLightUpdates() {
        return this.pendingLightUpdates;
    }

    @Override
    public long getLightUpdateTime() {
        return this.lightUpdateTime;
    }

    @Override
    public void setLightUpdateTime(long time) {
        this.lightUpdateTime = time;
    }

    @Inject(method={"onTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickHead(boolean skipRecheckGaps, CallbackInfo ci) {
        if (!this.field_76637_e.field_72995_K) {
            List<Chunk> neighbors = this.getSurroundingChunks();
            if (this.field_76650_s && this.field_76637_e.field_73011_w.func_191066_m() && !skipRecheckGaps && !neighbors.isEmpty()) {
                this.lightExecutorService.execute(() -> this.recheckGapsAsync(neighbors));
                this.field_76650_s = false;
            }
            this.field_150815_m = true;
            if (!this.field_150814_l && this.field_76646_k && !neighbors.isEmpty()) {
                this.lightExecutorService.execute(() -> this.checkLightAsync(neighbors));
                this.field_150814_l = true;
            }
            while (!this.field_177447_w.isEmpty()) {
                BlockPos blockpos = this.field_177447_w.poll();
                if (this.func_177424_a(blockpos, Chunk.EnumCreateEntityType.CHECK) != null || !this.func_177435_g(blockpos).func_177230_c().func_149716_u()) continue;
                TileEntity tileentity = this.func_177422_i(blockpos);
                this.field_76637_e.func_175690_a(blockpos, tileentity);
                this.field_76637_e.func_175704_b(blockpos, blockpos);
            }
            ci.cancel();
        }
    }

    @Redirect(method={"checkSkylightNeighborHeight"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getHeight(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;"))
    private BlockPos onCheckSkylightGetHeight(World world, BlockPos pos) {
        Chunk chunk = this.getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, null);
        if (chunk == null) {
            return DUMMY_POS;
        }
        return new BlockPos(pos.func_177958_n(), chunk.func_76611_b(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF), pos.func_177952_p());
    }

    @Redirect(method={"updateSkylightNeighborHeight"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;I)Z"))
    private boolean onAreaLoadedSkyLightNeighbor(World world, BlockPos pos, int radius) {
        return this.isAreaLoaded();
    }

    @Redirect(method={"updateSkylightNeighborHeight"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;checkLightFor(Lnet/minecraft/world/EnumSkyBlock;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onCheckLightForSkylightNeighbor(World world, EnumSkyBlock enumSkyBlock, BlockPos pos) {
        if (world.field_72995_K) {
            return world.func_180500_c(enumSkyBlock, pos);
        }
        return this.checkWorldLightFor(enumSkyBlock, pos);
    }

    private void recheckGapsAsync(List<Chunk> neighbors) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (!this.field_76639_c[i + j * 16]) continue;
                this.field_76639_c[i + j * 16] = false;
                int k = this.func_76611_b(i, j);
                int l = this.field_76635_g * 16 + i;
                int i1 = this.field_76647_h * 16 + j;
                int j1 = Integer.MAX_VALUE;
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    Chunk chunk = this.getLightChunk(l + enumfacing.func_82601_c() >> 4, i1 + enumfacing.func_82599_e() >> 4, neighbors);
                    if (chunk == null || chunk.field_189550_d) continue;
                    j1 = Math.min(j1, chunk.func_177442_v());
                }
                this.func_76599_g(l, i1, j1);
                for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                    this.func_76599_g(l + enumfacing1.func_82601_c(), i1 + enumfacing1.func_82599_e(), k);
                }
            }
        }
    }

    @Redirect(method={"enqueueRelightChecks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"))
    private IBlockState onRelightChecksGetBlockState(World world, BlockPos pos) {
        Chunk chunk = ((IMixinChunkProviderServer)world.func_72863_F()).getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        IMixinChunk spongeChunk = (IMixinChunk)chunk;
        if (chunk == null || chunk.field_189550_d || !spongeChunk.areNeighborsLoaded()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return chunk.func_177435_g(pos);
    }

    @Redirect(method={"enqueueRelightChecks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;checkLight(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onRelightChecksCheckLight(World world, BlockPos pos) {
        if (!this.field_76637_e.field_72995_K) {
            return this.checkWorldLight(pos);
        }
        return world.func_175664_x(pos);
    }

    @Redirect(method={"checkLight(II)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;checkLight(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onCheckLightWorld(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            return this.checkWorldLight(pos);
        }
        return world.func_175664_x(pos);
    }

    /*
     * Unable to fully structure code
     */
    @Inject(method={"checkLight"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkLightHead(CallbackInfo ci) {
        if (!this.field_76637_e.field_72995_K) {
            if (this.field_76637_e.func_73046_m().func_71241_aa() || this.lightExecutorService.isShutdown()) {
                return;
            }
            if (this.isQueuedForUnload()) {
                return;
            }
            neighborChunks = this.getSurroundingChunks();
            if (neighborChunks.isEmpty()) {
                this.field_150814_l = false;
                return;
            }
            if (SpongeImpl.getServer().func_152345_ab()) {
                try {
                    this.lightExecutorService.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$checkLightHead$2(java.util.List ), ()V)((MixinChunk_Async_Lighting)this, neighborChunks));
                }
                catch (RejectedExecutionException e) {
                    if (this.field_76637_e.func_73046_m().func_71241_aa() || this.lightExecutorService.isShutdown()) ** GOTO lbl18
                    throw e;
                }
            } else {
                this.checkLightAsync(neighborChunks);
            }
lbl18:
            // 3 sources

            ci.cancel();
        }
    }

    private void checkLightAsync(List<Chunk> neighbors) {
        this.field_76646_k = true;
        this.field_150814_l = true;
        BlockPos blockpos = new BlockPos(this.field_76635_g << 4, 0, this.field_76647_h << 4);
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            block0: for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (this.checkLightAsync(i, j, neighbors)) continue;
                    this.field_150814_l = false;
                    break block0;
                }
            }
            if (this.field_150814_l) {
                Iterator iterator = EnumFacing.Plane.HORIZONTAL.iterator();
                while (iterator.hasNext()) {
                    EnumFacing enumfacing;
                    int k = (enumfacing = (EnumFacing)iterator.next()).func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 16 : 1;
                    BlockPos pos = blockpos.func_177967_a(enumfacing, k);
                    Chunk chunk = this.getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, neighbors);
                    if (chunk == null) continue;
                    chunk.func_180700_a(enumfacing.func_176734_d());
                }
                this.func_177441_y();
            }
        }
    }

    private boolean checkLightAsync(int x, int z, List<Chunk> neighbors) {
        int i = this.func_76625_h();
        boolean flag = false;
        boolean flag1 = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos((this.field_76635_g << 4) + x, 0, (this.field_76647_h << 4) + z);
        for (int j = i + 16 - 1; j > this.field_76637_e.func_181545_F() || j > 0 && !flag1; --j) {
            blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos.func_177958_n(), j, blockpos$mutableblockpos.func_177952_p());
            int k = this.func_177435_g((BlockPos)blockpos$mutableblockpos).func_185891_c();
            if (k == 255 && blockpos$mutableblockpos.func_177956_o() < this.field_76637_e.func_181545_F()) {
                flag1 = true;
            }
            if (!flag && k > 0) {
                flag = true;
                continue;
            }
            if (!flag || k != 0 || this.checkWorldLight((BlockPos)blockpos$mutableblockpos, neighbors)) continue;
            return false;
        }
        for (int l = blockpos$mutableblockpos.func_177956_o(); l > 0; --l) {
            blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos.func_177958_n(), l, blockpos$mutableblockpos.func_177952_p());
            if (this.func_177435_g((BlockPos)blockpos$mutableblockpos).func_185906_d() <= 0) continue;
            this.checkWorldLight((BlockPos)blockpos$mutableblockpos, neighbors);
        }
        return true;
    }

    private Chunk getLightChunk(int chunkX, int chunkZ, List<Chunk> neighbors) {
        Chunk currentChunk = (Chunk)this;
        if (currentChunk.func_76600_a(chunkX, chunkZ)) {
            if (currentChunk.field_189550_d) {
                return null;
            }
            return currentChunk;
        }
        if (neighbors == null && (neighbors = this.getSurroundingChunks()).isEmpty()) {
            return null;
        }
        for (Chunk neighbor : neighbors) {
            if (!neighbor.func_76600_a(chunkX, chunkZ)) continue;
            if (neighbor.field_189550_d) {
                return null;
            }
            return neighbor;
        }
        return null;
    }

    private boolean isAreaLoaded() {
        if (!this.areNeighborsLoaded()) {
            return false;
        }
        Chunk southEastChunk = ((IMixinChunk)this.getNeighborChunk(0)).getNeighborChunk(2);
        if (southEastChunk == null) {
            return false;
        }
        Chunk southWestChunk = ((IMixinChunk)this.getNeighborChunk(0)).getNeighborChunk(3);
        if (southWestChunk == null) {
            return false;
        }
        Chunk northEastChunk = ((IMixinChunk)this.getNeighborChunk(1)).getNeighborChunk(2);
        if (northEastChunk == null) {
            return false;
        }
        Chunk northWestChunk = ((IMixinChunk)this.getNeighborChunk(1)).getNeighborChunk(3);
        return northWestChunk != null;
    }

    private List<Chunk> getSurroundingChunks() {
        if (!this.areNeighborsLoaded()) {
            return EMPTY_LIST;
        }
        Chunk southEastChunk = ((IMixinChunk)this.getNeighborChunk(0)).getNeighborChunk(2);
        if (southEastChunk == null) {
            return EMPTY_LIST;
        }
        Chunk southWestChunk = ((IMixinChunk)this.getNeighborChunk(0)).getNeighborChunk(3);
        if (southWestChunk == null) {
            return EMPTY_LIST;
        }
        Chunk northEastChunk = ((IMixinChunk)this.getNeighborChunk(1)).getNeighborChunk(2);
        if (northEastChunk == null) {
            return EMPTY_LIST;
        }
        Chunk northWestChunk = ((IMixinChunk)this.getNeighborChunk(1)).getNeighborChunk(3);
        if (northWestChunk == null) {
            return EMPTY_LIST;
        }
        List<Object> chunkList = new ArrayList();
        chunkList = this.getNeighbors();
        chunkList.add(southEastChunk);
        chunkList.add(southWestChunk);
        chunkList.add(northEastChunk);
        chunkList.add(northWestChunk);
        return chunkList;
    }

    @Inject(method={"relightBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRelightBlock(int x, int y, int z, CallbackInfo ci) {
        if (!this.field_76637_e.field_72995_K) {
            this.lightExecutorService.execute(() -> this.relightBlockAsync(x, y, z));
            ci.cancel();
        }
    }

    private void relightBlockAsync(int x, int y, int z) {
        int i;
        int j = i = this.field_76634_f[z << 4 | x] & 0xFF;
        if (y > i) {
            j = y;
        }
        while (j > 0 && this.func_150808_b(x, j - 1, z) == 0) {
            --j;
        }
        if (j != i) {
            this.markBlocksDirtyVerticalAsync(x + this.field_76635_g * 16, z + this.field_76647_h * 16, j, i);
            this.field_76634_f[z << 4 | x] = j;
            int k = this.field_76635_g * 16 + x;
            int l = this.field_76647_h * 16 + z;
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                if (j < i) {
                    for (int j1 = j; j1 < i; ++j1) {
                        ExtendedBlockStorage extendedblockstorage2 = this.field_76652_q[j1 >> 4];
                        if (extendedblockstorage2 == Chunk.field_186036_a) continue;
                        extendedblockstorage2.func_76657_c(x, j1 & 0xF, z, 15);
                        this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + x, j1, (this.field_76647_h << 4) + z));
                    }
                } else {
                    for (int i1 = i; i1 < j; ++i1) {
                        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[i1 >> 4];
                        if (extendedblockstorage == Chunk.field_186036_a) continue;
                        extendedblockstorage.func_76657_c(x, i1 & 0xF, z, 0);
                        this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + x, i1, (this.field_76647_h << 4) + z));
                    }
                }
                int k1 = 15;
                while (j > 0 && k1 > 0) {
                    ExtendedBlockStorage extendedblockstorage1;
                    int i2;
                    if ((i2 = this.func_150808_b(x, --j, z)) == 0) {
                        i2 = 1;
                    }
                    if ((k1 -= i2) < 0) {
                        k1 = 0;
                    }
                    if ((extendedblockstorage1 = this.field_76652_q[j >> 4]) == Chunk.field_186036_a) continue;
                    extendedblockstorage1.func_76657_c(x, j & 0xF, z, k1);
                }
            }
            int l1 = this.field_76634_f[z << 4 | x];
            int j2 = i;
            int k2 = l1;
            if (l1 < i) {
                j2 = l1;
                k2 = i;
            }
            if (l1 < this.field_82912_p) {
                this.field_82912_p = l1;
            }
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    this.func_76609_d(k + enumfacing.func_82601_c(), l + enumfacing.func_82599_e(), j2, k2);
                }
                this.func_76609_d(k, l, j2, k2);
            }
            this.field_76643_l = true;
        }
    }

    private void markBlocksDirtyVerticalAsync(int x1, int z1, int x2, int z2) {
        if (x2 > z2) {
            int i = z2;
            z2 = x2;
            x2 = i;
        }
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            for (int j = x2; j <= z2; ++j) {
                BlockPos pos = new BlockPos(x1, j, z1);
                Chunk chunk = this.getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, null);
                if (chunk == null) continue;
                ((IMixinWorldServer)this.field_76637_e).updateLightAsync(EnumSkyBlock.SKY, new BlockPos(x1, j, z1), chunk);
            }
        }
        this.field_76637_e.func_147458_c(x1, x2, z1, x1, z2, z1);
    }

    private boolean checkWorldLightFor(EnumSkyBlock lightType, BlockPos pos) {
        Chunk chunk = this.getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, null);
        if (chunk == null) {
            return false;
        }
        return ((IMixinWorldServer)this.field_76637_e).updateLightAsync(lightType, pos, chunk);
    }

    private boolean checkWorldLight(BlockPos pos) {
        return this.checkWorldLight(pos, null);
    }

    private boolean checkWorldLight(BlockPos pos, List<Chunk> neighbors) {
        boolean flag = false;
        Chunk chunk = this.getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, neighbors);
        if (chunk == null) {
            return false;
        }
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            flag |= ((IMixinWorldServer)this.field_76637_e).updateLightAsync(EnumSkyBlock.SKY, pos, chunk);
        }
        return flag |= ((IMixinWorldServer)this.field_76637_e).updateLightAsync(EnumSkyBlock.BLOCK, pos, chunk);
    }

    @Override
    public CopyOnWriteArrayList<Short> getQueuedLightingUpdates(EnumSkyBlock type) {
        if (type == EnumSkyBlock.SKY) {
            return this.queuedSkyLightingUpdates;
        }
        return this.queuedBlockLightingUpdates;
    }

    private /* synthetic */ void lambda$checkLightHead$2(List neighborChunks) {
        this.checkLightAsync(neighborChunks);
    }
}

