/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.tileentity.carrier.Hopper;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.tileentity.CooldownData;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinInventory;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.ReusableLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.mixin.core.tileentity.MixinTileEntityLockableLoot;

@NonnullByDefault
@Mixin(value={TileEntityHopper.class})
public abstract class MixinTileEntityHopper
extends MixinTileEntityLockableLoot
implements Hopper,
IMixinInventory {
    @Shadow
    public int field_145901_j;
    public List<SlotTransaction> capturedTransactions = new ArrayList<SlotTransaction>();

    @Shadow
    private static ItemStack func_174916_c(IInventory source, IInventory destination, ItemStack stack, int index, EnumFacing direction) {
        throw new AbstractMethodError("Shadow");
    }

    @Shadow
    public static IInventory func_145884_b(IHopper hopper) {
        throw new AbstractMethodError("Shadow");
    }

    @Shadow
    private static boolean func_174917_b(IInventory inventoryIn, EnumFacing side) {
        throw new AbstractMethodError("Shadow");
    }

    @Shadow
    protected abstract boolean func_174919_a(IInventory var1, EnumFacing var2);

    @Override
    public List<SlotTransaction> getCapturedTransactions() {
        return this.capturedTransactions;
    }

    @Override
    public ReusableLens<?> generateLens(Fabric<IInventory> fabric, InventoryAdapter<IInventory, ItemStack> adapter) {
        return ReusableLens.getLens(GridInventoryLens.class, (InventoryAdapter)((Object)this), this::generateSlotProvider, this::generateRootLens);
    }

    private SlotProvider<IInventory, ItemStack> generateSlotProvider() {
        return new SlotCollection.Builder().add(5).build();
    }

    private GridInventoryLens<IInventory, ItemStack> generateRootLens(SlotProvider<IInventory, ItemStack> slots) {
        Class<?> thisClass = this.getClass();
        return new GridInventoryLensImpl(0, 5, 1, 5, thisClass, slots);
    }

    @Inject(method={"putDropInInventoryAllSlots"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityItem;getItem()Lnet/minecraft/item/ItemStack;")})
    private static void onPutDrop(IInventory inventory, IInventory hopper, EntityItem entityItem, CallbackInfoReturnable<Boolean> callbackInfo) {
        ((IMixinEntity)entityItem).getCreatorUser().ifPresent(owner -> {
            if (inventory instanceof TileEntity) {
                TileEntity te = (TileEntity)inventory;
                BlockPos pos = te.func_174877_v();
                IMixinChunk spongeChunk = (IMixinChunk)te.func_145831_w().func_175726_f(pos);
                spongeChunk.addTrackedBlockPosition(te.func_145838_q(), pos, (User)owner, PlayerTracker.Type.NOTIFIER);
            }
        });
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = super.toContainer();
        return container.set(DataQuery.of("TransferCooldown"), (Object)this.field_145901_j);
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        Optional<CooldownData> cooldownData = this.get(CooldownData.class);
        if (cooldownData.isPresent()) {
            manipulators.add(cooldownData.get());
        }
    }

    @Redirect(method={"pullItems"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityHopper;isInventoryEmpty(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/util/EnumFacing;)Z"))
    private static boolean onIsInventoryEmpty(IInventory inventory, EnumFacing facing, IHopper hopper) {
        boolean result = MixinTileEntityHopper.func_174917_b(inventory, facing);
        if (result || !ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_PRE) {
            return result;
        }
        return SpongeCommonEventFactory.callTransferPre(SpongeCommonEventFactory.toInventory(inventory), SpongeCommonEventFactory.toInventory((IInventory)hopper)).isCancelled();
    }

    @Redirect(method={"transferItemsOut"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityHopper;isInventoryFull(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/util/EnumFacing;)Z"))
    private boolean onIsInventoryFull(TileEntityHopper hopper, IInventory inventory, EnumFacing enumfacing) {
        boolean result = this.func_174919_a(inventory, enumfacing);
        if (result || !ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_PRE) {
            return result;
        }
        return SpongeCommonEventFactory.callTransferPre(SpongeCommonEventFactory.toInventory((IInventory)hopper), SpongeCommonEventFactory.toInventory(inventory)).isCancelled();
    }

    @Redirect(method={"putStackInInventoryAllSlots"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityHopper;insertStack(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/item/ItemStack;ILnet/minecraft/util/EnumFacing;)Lnet/minecraft/item/ItemStack;"))
    private static ItemStack onInsertStack(IInventory source, IInventory destination, ItemStack stack, int index, EnumFacing direction) {
        if (!(source instanceof IMixinInventory) && !(destination instanceof IMixinInventory) || !(destination instanceof InventoryAdapter)) {
            return MixinTileEntityHopper.func_174916_c(source, destination, stack, index, direction);
        }
        if (!ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST) {
            return MixinTileEntityHopper.func_174916_c(source, destination, stack, index, direction);
        }
        IMixinInventory captureIn = MixinTileEntityHopper.forCapture(source);
        if (captureIn == null) {
            captureIn = MixinTileEntityHopper.forCapture(destination);
        }
        return SpongeCommonEventFactory.captureTransaction(captureIn, SpongeCommonEventFactory.toInventory(destination), index, () -> MixinTileEntityHopper.func_174916_c(source, destination, stack, index, direction));
    }

    @Inject(method={"transferItemsOut"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=1)})
    private void afterPutStackInSlots(CallbackInfoReturnable<Boolean> cir, IInventory iInventory, EnumFacing enumFacing, int i, ItemStack itemStack, ItemStack itemStack1) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST && itemStack1.func_190926_b()) {
            IMixinInventory capture = MixinTileEntityHopper.forCapture(this);
            Inventory source = SpongeCommonEventFactory.toInventory(this);
            SpongeCommonEventFactory.captureTransaction(capture, source, i, itemStack);
            if (SpongeCommonEventFactory.callTransferPost(capture, source, SpongeCommonEventFactory.toInventory(iInventory))) {
                itemStack1 = itemStack;
            }
        }
    }

    @Inject(method={"pullItemFromSlot"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=1)})
    private static void afterPullItemFromSlot(IHopper hopper, IInventory iInventory, int index, EnumFacing direction, CallbackInfoReturnable<Boolean> cir, ItemStack itemStack, ItemStack itemStack1, ItemStack itemStack2) {
        if (ShouldFire.CHANGE_INVENTORY_EVENT_TRANSFER_POST && itemStack2.func_190926_b()) {
            IMixinInventory capture = MixinTileEntityHopper.forCapture(hopper);
            Inventory source = SpongeCommonEventFactory.toInventory(iInventory);
            SpongeCommonEventFactory.captureTransaction(capture, source, index, itemStack1);
            if (SpongeCommonEventFactory.callTransferPost(capture, source, SpongeCommonEventFactory.toInventory((IInventory)hopper))) {
                itemStack1 = itemStack;
            }
        }
    }

    @Nullable
    private static IMixinInventory forCapture(Object toCapture) {
        if (toCapture instanceof IMixinInventory) {
            return (IMixinInventory)toCapture;
        }
        return null;
    }
}

