/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.text;

import java.util.Iterator;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ObjectUtils;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.interfaces.text.IMixinClickEvent;
import org.spongepowered.common.interfaces.text.IMixinHoverEvent;
import org.spongepowered.common.interfaces.text.IMixinTextComponent;
import org.spongepowered.common.text.ResolvedChatStyle;
import org.spongepowered.common.text.TextComponentIterable;
import org.spongepowered.common.text.format.SpongeTextColor;

@Mixin(value={TextComponentBase.class})
public abstract class MixinTextComponentBase
implements IMixinTextComponent {
    @Shadow
    private Style field_150263_b;
    @Shadow
    protected List<ITextComponent> field_150264_a;

    protected Text.Builder createBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ITextComponent> childrenIterator() {
        return this.func_150253_a().iterator();
    }

    @Override
    public Iterable<ITextComponent> withChildren() {
        return new TextComponentIterable(this, true);
    }

    @Override
    public String toPlain() {
        StringBuilder builder = new StringBuilder();
        for (ITextComponent component : this.withChildren()) {
            builder.append(component.func_150261_e());
        }
        return builder.toString();
    }

    private StringBuilder getLegacyFormattingBuilder() {
        StringBuilder builder = new StringBuilder();
        Style style = this.func_150256_b();
        MixinTextComponentBase.apply(builder, '\u00a7', (TextFormatting)ObjectUtils.defaultIfNull((Object)style.func_150215_a(), (Object)TextFormatting.RESET));
        MixinTextComponentBase.apply(builder, '\u00a7', TextFormatting.BOLD, style.func_150223_b());
        MixinTextComponentBase.apply(builder, '\u00a7', TextFormatting.ITALIC, style.func_150242_c());
        MixinTextComponentBase.apply(builder, '\u00a7', TextFormatting.UNDERLINE, style.func_150234_e());
        MixinTextComponentBase.apply(builder, '\u00a7', TextFormatting.STRIKETHROUGH, style.func_150236_d());
        MixinTextComponentBase.apply(builder, '\u00a7', TextFormatting.OBFUSCATED, style.func_150233_f());
        return builder;
    }

    @Override
    public String getLegacyFormatting() {
        return this.getLegacyFormattingBuilder().toString();
    }

    @Override
    public String toLegacy(char code) {
        StringBuilder builder = new StringBuilder();
        ResolvedChatStyle current = null;
        Style previous = null;
        for (ITextComponent component : this.withChildren()) {
            Style newStyle = component.func_150256_b();
            ResolvedChatStyle style = MixinTextComponentBase.resolve(current, previous, newStyle);
            previous = newStyle;
            if (current == null || current.color != style.color || current.bold && !style.bold || current.italic && !style.italic || current.underlined && !style.underlined || current.strikethrough && !style.strikethrough || current.obfuscated && !style.obfuscated) {
                if (style.color != null) {
                    MixinTextComponentBase.apply(builder, code, style.color);
                } else if (current != null) {
                    MixinTextComponentBase.apply(builder, code, TextFormatting.RESET);
                }
                MixinTextComponentBase.apply(builder, code, TextFormatting.BOLD, style.bold);
                MixinTextComponentBase.apply(builder, code, TextFormatting.ITALIC, style.italic);
                MixinTextComponentBase.apply(builder, code, TextFormatting.UNDERLINE, style.underlined);
                MixinTextComponentBase.apply(builder, code, TextFormatting.STRIKETHROUGH, style.strikethrough);
                MixinTextComponentBase.apply(builder, code, TextFormatting.OBFUSCATED, style.obfuscated);
            } else {
                MixinTextComponentBase.apply(builder, code, TextFormatting.BOLD, current.bold != style.bold);
                MixinTextComponentBase.apply(builder, code, TextFormatting.ITALIC, current.italic != style.italic);
                MixinTextComponentBase.apply(builder, code, TextFormatting.UNDERLINE, current.underlined != style.underlined);
                MixinTextComponentBase.apply(builder, code, TextFormatting.STRIKETHROUGH, current.strikethrough != style.strikethrough);
                MixinTextComponentBase.apply(builder, code, TextFormatting.OBFUSCATED, current.obfuscated != style.obfuscated);
            }
            current = style;
            builder.append(component.func_150261_e());
        }
        return builder.toString();
    }

    @Override
    public String toLegacySingle(char code) {
        return this.getLegacyFormattingBuilder().append(this.func_150261_e()).toString();
    }

    private static ResolvedChatStyle resolve(ResolvedChatStyle current, Style previous, Style style) {
        if (current != null && style.field_150249_a == previous) {
            return new ResolvedChatStyle((TextFormatting)ObjectUtils.defaultIfNull((Object)style.field_150247_b, (Object)current.color), MixinTextComponentBase.firstNonNull(style.field_150248_c, current.bold), MixinTextComponentBase.firstNonNull(style.field_150245_d, current.italic), MixinTextComponentBase.firstNonNull(style.field_150246_e, current.underlined), MixinTextComponentBase.firstNonNull(style.field_150243_f, current.strikethrough), MixinTextComponentBase.firstNonNull(style.field_150244_g, current.obfuscated));
        }
        return new ResolvedChatStyle(style.func_150215_a(), style.func_150223_b(), style.func_150242_c(), style.func_150234_e(), style.func_150236_d(), style.func_150233_f());
    }

    private static boolean firstNonNull(Boolean b1, boolean b2) {
        return b1 != null ? b1 : b2;
    }

    private static void apply(StringBuilder builder, char code, TextFormatting formatting) {
        builder.append(code).append(formatting.field_96329_z);
    }

    private static void apply(StringBuilder builder, char code, TextFormatting formatting, boolean state) {
        if (state) {
            MixinTextComponentBase.apply(builder, code, formatting);
        }
    }

    @Override
    public Text toText() {
        Text.Builder builder = this.createBuilder();
        if (this.field_150263_b != null) {
            if (this.field_150263_b.field_150247_b != null) {
                builder.color(SpongeTextColor.of(this.field_150263_b.field_150247_b));
            }
            builder.style(new TextStyle(this.field_150263_b.field_150248_c, this.field_150263_b.field_150245_d, this.field_150263_b.field_150246_e, this.field_150263_b.field_150243_f, this.field_150263_b.field_150244_g));
            if (this.field_150263_b.field_150251_h != null) {
                builder.onClick(((IMixinClickEvent)this.field_150263_b.field_150251_h).getHandle());
            }
            if (this.field_150263_b.field_150252_i != null) {
                builder.onHover(((IMixinHoverEvent)this.field_150263_b.field_150252_i).getHandle());
            }
            if (this.field_150263_b.field_179990_j != null) {
                builder.onShiftClick(TextActions.insertText(this.field_150263_b.field_179990_j));
            }
        }
        for (ITextComponent child : this.field_150264_a) {
            builder.append(((IMixinTextComponent)child).toText());
        }
        return builder.build();
    }
}

