/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityThrowable.class})
public abstract class MixinEntityThrowable
extends MixinEntity
implements Projectile {
    @Shadow
    private EntityLivingBase field_70192_c;
    @Shadow
    private String field_85053_h;
    @Nullable
    public ProjectileSource projectileSource;

    @Shadow
    public abstract EntityLivingBase func_85052_h();

    @Shadow
    protected abstract void func_70184_a(RayTraceResult var1);

    @Override
    public ProjectileSource getShooter() {
        if (this.projectileSource != null) {
            return this.projectileSource;
        }
        if (this.func_85052_h() != null && this.func_85052_h() instanceof ProjectileSource) {
            return (ProjectileSource)this.func_85052_h();
        }
        return ProjectileSource.UNKNOWN;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        this.field_70192_c = shooter instanceof EntityLivingBase ? (EntityLivingBase)shooter : null;
        this.field_85053_h = null;
        this.projectileSource = shooter;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, this);
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, this.getShooter(), (Entity)this.field_70192_c);
    }

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/projectile/EntityThrowable;onImpact(Lnet/minecraft/util/math/RayTraceResult;)V"))
    public void onProjectileImpact(EntityThrowable projectile, RayTraceResult movingObjectPosition) {
        if (this.field_70170_p.field_72995_K || movingObjectPosition.field_72313_a == RayTraceResult.Type.MISS) {
            this.func_70184_a(movingObjectPosition);
            return;
        }
        if (!SpongeCommonEventFactory.handleCollideImpactEvent((Entity)projectile, this.getShooter(), movingObjectPosition)) {
            this.func_70184_a(movingObjectPosition);
        }
    }
}

