/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.MutableLensSet;
import org.spongepowered.common.item.inventory.lens.impl.collections.MutableLensSetImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.query.SpongeQueryOperation;
import org.spongepowered.common.item.inventory.query.result.MinecraftResultAdapterProvider;
import org.spongepowered.common.item.inventory.query.result.QueryResult;

public class Query<TInventory, TStack> {
    private static ResultAdapterProvider<?, ?> defaultResultProvider = new MinecraftResultAdapterProvider();
    private final InventoryAdapter<TInventory, TStack> adapter;
    private final Fabric<TInventory> inventory;
    private final Lens<TInventory, TStack> lens;
    private final QueryOperation<?>[] queries;

    private Query(InventoryAdapter<TInventory, TStack> adapter, QueryOperation<?>[] queries) {
        this.adapter = adapter;
        this.inventory = adapter.getFabric();
        this.lens = adapter.getRootLens();
        this.queries = queries;
    }

    public Inventory execute() {
        return this.execute(defaultResultProvider);
    }

    public Inventory execute(ResultAdapterProvider<TInventory, TStack> resultProvider) {
        if (this.matches(this.lens, null, this.inventory)) {
            return this.lens.getAdapter(this.inventory, this.adapter);
        }
        return this.toResult(resultProvider, this.reduce(this.lens, this.depthFirstSearch(this.lens)));
    }

    private Inventory toResult(ResultAdapterProvider<TInventory, TStack> resultProvider, MutableLensSet<TInventory, TStack> matches) {
        if (matches.isEmpty()) {
            return new EmptyInventoryImpl(this.adapter);
        }
        if (matches.size() == 1) {
            return matches.getLens(0).getAdapter(this.inventory, this.adapter);
        }
        if (resultProvider != null) {
            return resultProvider.getResultAdapter(this.inventory, matches, this.adapter);
        }
        return defaultResultProvider.getResultAdapter(this.inventory, matches, this.adapter);
    }

    private MutableLensSet<TInventory, TStack> depthFirstSearch(Lens<TInventory, TStack> lens) {
        MutableLensSetImpl matches = new MutableLensSetImpl(true);
        for (Lens<TInventory, TStack> child : lens.getChildren()) {
            if (child == null) continue;
            if (!child.getChildren().isEmpty()) {
                matches.addAll(this.depthFirstSearch(child));
            }
            if (!this.matches(child, lens, this.inventory)) continue;
            matches.add(child);
        }
        if (matches.size() < 2) {
            return matches;
        }
        return matches;
    }

    private boolean matches(Lens<TInventory, TStack> lens, Lens<TInventory, TStack> parent, Fabric<TInventory> inventory) {
        for (QueryOperation<?> operation : this.queries) {
            if (!((SpongeQueryOperation)operation).matches(lens, parent, inventory)) continue;
            return true;
        }
        return false;
    }

    private MutableLensSet<TInventory, TStack> reduce(Lens<TInventory, TStack> lens, MutableLensSet<TInventory, TStack> matches) {
        if (lens.getSlots().equals(this.getSlots(matches)) && this.allLensesAreSlots(matches)) {
            matches.clear();
            matches.add(lens);
            return matches;
        }
        for (Lens<TInventory, TStack> child : lens.getChildren()) {
            if (child == null || !child.isSubsetOf(matches)) continue;
            matches.removeAll(child.getChildren());
            matches.add(child);
        }
        return matches;
    }

    private boolean allLensesAreSlots(MutableLensSet<TInventory, TStack> lenses) {
        for (Lens lens : lenses) {
            if (lens instanceof SlotLens) continue;
            return false;
        }
        return true;
    }

    private IntSet getSlots(Collection<Lens<TInventory, TStack>> lenses) {
        IntOpenHashSet slots = new IntOpenHashSet();
        for (Lens<TInventory, TStack> lens : lenses) {
            slots.addAll((IntCollection)lens.getSlots());
        }
        return slots;
    }

    public static <TInventory, TStack> Query<TInventory, TStack> compile(InventoryAdapter<TInventory, TStack> adapter, QueryOperation<?> ... queries) {
        return new Query<TInventory, TStack>(adapter, queries);
    }

    public static void setDefaultResultProvider(ResultAdapterProvider<?, ?> defaultResultProvider) {
        Query.defaultResultProvider = defaultResultProvider;
    }

    public static interface ResultAdapterProvider<TInventory, TStack> {
        public QueryResult<TInventory, TStack> getResultAdapter(Fabric<TInventory> var1, MutableLensSet<TInventory, TStack> var2, Inventory var3);
    }
}

