/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import com.google.common.base.Preconditions;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.UnsupportedFabricException;
import org.spongepowered.common.item.inventory.lens.impl.fabric.CompoundFabric;
import org.spongepowered.common.item.inventory.lens.impl.fabric.ContainerFabric;
import org.spongepowered.common.item.inventory.lens.impl.fabric.IInventoryFabric;
import org.spongepowered.common.item.inventory.lens.impl.fabric.SlotFabric;

public abstract class MinecraftFabric
implements Fabric<IInventory> {
    public static <TFabric> Fabric<IInventory> of(TFabric target) {
        Preconditions.checkNotNull(target, (Object)"Fabric target");
        if (target instanceof Fabric) {
            return (Fabric)target;
        }
        if (target instanceof Slot) {
            Slot slot = (Slot)target;
            if (slot.field_75224_c == null) {
                return new SlotFabric(slot);
            }
            return new IInventoryFabric(slot.field_75224_c);
        }
        if (target instanceof Container) {
            return new ContainerFabric((Container)target);
        }
        if (target instanceof InventoryLargeChest) {
            return new CompoundFabric(new IInventoryFabric((IInventory)((InventoryLargeChest)target).field_70477_b), new IInventoryFabric((IInventory)((InventoryLargeChest)target).field_70478_c));
        }
        if (target instanceof IInventory) {
            return new IInventoryFabric((IInventory)target);
        }
        throw new UnsupportedFabricException("Container of type %s could not be used as an inventory fabric", target.getClass());
    }

    public static InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> fabric, Inventory parent, int base, Class<? extends Inventory> adapterType) {
        IInventory inventory = fabric.get(base);
        if (inventory.getClass() == adapterType) {
            return (InventoryAdapter)inventory;
        }
        if (fabric instanceof ContainerFabric && (inventory = MinecraftFabric.of(inventory).get(base)).getClass() == adapterType) {
            return (InventoryAdapter)inventory;
        }
        return null;
    }
}

