/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

class PlayerTickPhaseState
extends TickPhaseState<PlayerTickContext> {
    PlayerTickPhaseState() {
    }

    @Override
    public PlayerTickContext createPhaseContext() {
        return (PlayerTickContext)((PlayerTickContext)new PlayerTickContext().addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(PlayerTickContext phaseContext) {
        Player player = phaseContext.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a Player!", phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PASSIVE);
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(spawnEntityEvent);
                for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                    EntityUtil.toMixin(entity).setCreator(player.getUniqueId());
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            });
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), capturedEntities);
                SpongeImpl.postEvent(spawnEntityEvent);
                for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                    EntityUtil.toMixin(entity).setCreator(player.getUniqueId());
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            });
            phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, PlayerTickContext context) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.owner(player);
        explosionContext.notifier(player);
        explosionContext.source(player);
    }

    @Override
    public boolean spawnEntityOrCapture(PlayerTickContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a Player!", context));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PASSIVE);
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(spawnEntityEvent);
            if (!spawnEntityEvent.isCancelled()) {
                for (org.spongepowered.api.entity.Entity anEntity : spawnEntityEvent.getEntities()) {
                    EntityUtil.toMixin(anEntity).setCreator(player.getUniqueId());
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "PlayerTickPhase";
    }
}

