/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.world.BlockChange;

class PlaceBlockPacketState
extends BasicPacketState {
    PlaceBlockPacketState() {
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        CPacketPlayerTryUseItemOnBlock placeBlock = (CPacketPlayerTryUseItemOnBlock)packet;
        net.minecraft.item.ItemStack itemUsed = playerMP.func_184586_b(placeBlock.func_187022_c());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        context.itemUsed(itemstack);
    }

    @Override
    public void handleBlockChangeWithUser(@Nullable BlockChange blockChange, Transaction<BlockSnapshot> transaction, BasicPacketContext context) {
        Player player = Sponge.getCauseStackManager().getCurrentCause().first(Player.class).get();
        Location<World> location = transaction.getFinal().getLocation().get();
        BlockPos pos = ((IMixinLocation)((Object)location)).getBlockPos();
        IMixinChunk spongeChunk = (IMixinChunk)((WorldServer)location.getExtent()).func_175726_f(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.OWNER);
        }
        spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.NOTIFIER);
    }

    @Override
    public void addNotifierToBlockEvent(BasicPacketContext context, IMixinWorldServer mixinWorldServer, BlockPos pos, IMixinBlockEventData blockEvent) {
        Player player = Sponge.getCauseStackManager().getCurrentCause().first(Player.class).get();
        Location<World> location = new Location<World>(player.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        LocatableBlock locatableBlock = LocatableBlock.builder().location(location).state(location.getBlock()).build();
        blockEvent.setTickBlock(locatableBlock);
        blockEvent.setSourceUser(player);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        Object packet = context.getPacket();
        EntityPlayerMP player = context.getPacketPlayer();
        IMixinWorldServer mixinWorld = (IMixinWorldServer)player.field_70170_p;
        ItemStack itemStack = context.getItemUsed();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(player);
                Sponge.getCauseStackManager().pushCause(snapshot);
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.SPAWN_EGG);
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    PlaceBlockPacketState.processSpawnedEntities(player, spawnEntityEvent);
                }
            }
        });
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(originalBlocks -> {
            Sponge.getCauseStackManager().pushCause(player);
            boolean success = TrackingUtil.processBlockCaptures(originalBlocks, this, context);
            if (!success && snapshot != ItemTypeRegistryModule.NONE_SNAPSHOT) {
                Sponge.getCauseStackManager().pushCause(player);
                EnumHand hand = ((CPacketPlayerTryUseItemOnBlock)packet).func_187022_c();
                PacketPhaseUtil.handlePlayerSlotRestore(player, (net.minecraft.item.ItemStack)itemStack, hand);
            }
            Sponge.getCauseStackManager().popCause();
        });
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List entities = drops.stream().map(drop -> drop.create(player.func_71121_q())).map(EntityUtil::fromNative).collect(Collectors.toList());
            if (!entities.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                    Sponge.getCauseStackManager().pushCause(player);
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        for (Entity droppedItem : event.getEntities()) {
                            droppedItem.setCreator(player.func_110124_au());
                            mixinWorld.forceSpawnEntity(droppedItem);
                        }
                    }
                }
            }
        });
        IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
        mixinContainer.setCaptureInventory(false);
        mixinContainer.getCapturedTransactions().clear();
    }
}

