/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class DispensePhaseState
extends BlockPhaseState {
    DispensePhaseState() {
    }

    @Override
    public GeneralizedContext createPhaseContext() {
        return (GeneralizedContext)((GeneralizedContext)((GeneralizedContext)super.createPhaseContext().addBlockCaptures()).addEntityCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(GeneralizedContext phaseContext) {
        BlockSnapshot blockSnapshot = phaseContext.getSource(BlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dispensing items!", phaseContext));
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(blockSnapshot);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DISPENSE);
            phaseContext.addNotifierAndOwnerToCauseStack();
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                DropItemEvent.Dispense event = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
            phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(event);
                User user = phaseContext.getNotifier().orElseGet(() -> phaseContext.getOwner().orElse(null));
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                        if (user != null) {
                            EntityUtil.toMixin(entity).setCreator(user.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
        }
    }
}

