/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.block.tileentity.carrier.Dispenser;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;

public class DispenserSourceLogic
implements ProjectileSourceLogic<Dispenser> {
    DispenserSourceLogic() {
    }

    @Override
    public <P extends Projectile> Optional<P> launch(ProjectileLogic<P> logic, Dispenser source, Class<P> projectileClass, Object ... args) {
        if (args.length == 1 && args[0] instanceof Item) {
            return this.launch((TileEntityDispenser)source, projectileClass, (Item)args[0]);
        }
        Optional<P> projectile = logic.createProjectile(source, projectileClass, source.getLocation());
        if (projectile.isPresent()) {
            EnumFacing enumfacing = DispenserSourceLogic.getFacing((TileEntityDispenser)source);
            Entity projectileEntity = (Entity)projectile.get();
            projectileEntity.field_70159_w = enumfacing.func_82601_c();
            projectileEntity.field_70181_x = (float)enumfacing.func_96559_d() + 0.1f;
            projectileEntity.field_70179_y = enumfacing.func_82599_e();
        }
        return projectile;
    }

    public static EnumFacing getFacing(TileEntityDispenser dispenser) {
        IBlockState state = dispenser.func_145831_w().func_180495_p(dispenser.func_174877_v());
        return (EnumFacing)state.func_177229_b((IProperty)BlockDispenser.field_176441_a);
    }

    private <P extends Projectile> Optional<P> launch(TileEntityDispenser dispenser, Class<P> projectileClass, Item item) {
        BehaviorDefaultDispenseItem behavior = (BehaviorDefaultDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)item);
        List entityList = dispenser.func_145831_w().field_72996_f;
        int numEntities = entityList.size();
        behavior.func_82482_a((IBlockSource)new BlockSourceImpl(dispenser.func_145831_w(), dispenser.func_174877_v()), new ItemStack(item));
        for (int i = entityList.size() - 1; i >= numEntities; --i) {
            if (!projectileClass.isInstance(entityList.get(i))) continue;
            return Optional.of((Projectile)entityList.get(i));
        }
        return Optional.empty();
    }
}

