/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableSetValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeCollectionValue;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;

public class ImmutableSpongeSetValue<E>
extends ImmutableSpongeCollectionValue<E, Set<E>, ImmutableSetValue<E>, SetValue<E>>
implements ImmutableSetValue<E> {
    public ImmutableSpongeSetValue(Key<? extends BaseValue<Set<E>>> key) {
        super(key, ImmutableSet.of());
    }

    public ImmutableSpongeSetValue(Key<? extends BaseValue<Set<E>>> key, Set<E> actualValue) {
        super(key, ImmutableSet.of(), actualValue);
    }

    @Override
    public ImmutableSetValue<E> with(Set<E> value) {
        return new ImmutableSpongeSetValue<E>(this.getKey(), ImmutableSet.copyOf(value));
    }

    @Override
    public ImmutableSetValue<E> transform(Function<Set<E>, Set<E>> function) {
        return new ImmutableSpongeSetValue<E>(this.getKey(), (Set)Preconditions.checkNotNull(((Function)Preconditions.checkNotNull(function)).apply(this.actualValue)));
    }

    @Override
    public ImmutableSetValue<E> withElement(E elements) {
        return new ImmutableSpongeSetValue<E>(this.getKey(), ImmutableSet.builder().addAll((Iterable)this.actualValue).add(elements).build());
    }

    @Override
    public ImmutableSetValue<E> withAll(Iterable<E> elements) {
        return new ImmutableSpongeSetValue<E>(this.getKey(), ImmutableSet.builder().addAll((Iterable)this.actualValue).addAll(elements).build());
    }

    @Override
    public ImmutableSetValue<E> without(E element) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ((Set)this.actualValue).stream().filter(existing -> !existing.equals(element)).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return new ImmutableSpongeSetValue<E>(this.getKey(), builder.build());
    }

    @Override
    public ImmutableSetValue<E> withoutAll(Iterable<E> elements) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ((Set)this.actualValue).stream().filter(existingElement -> !Iterables.contains((Iterable)elements, (Object)existingElement)).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return new ImmutableSpongeSetValue<E>(this.getKey(), builder.build());
    }

    @Override
    public ImmutableSetValue<E> withoutAll(Predicate<E> predicate) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ((Set)this.actualValue).stream().filter(existingElement -> ((Predicate)Preconditions.checkNotNull((Object)predicate)).test(existingElement)).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return new ImmutableSpongeSetValue<E>(this.getKey(), builder.build());
    }

    @Override
    public Set<E> getAll() {
        HashSet set = Sets.newHashSet();
        set.addAll((Collection)this.actualValue);
        return set;
    }

    @Override
    public SetValue<E> asMutable() {
        HashSet set = Sets.newHashSet();
        set.addAll((Collection)this.actualValue);
        return new SpongeSetValue(this.getKey(), set);
    }
}

