/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAffectsSpawningData;
import org.spongepowered.api.data.manipulator.mutable.entity.AffectsSpawningData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAffectsSpawningData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;

public class AffectsSpawningDataProcessor
extends AbstractEntitySingleDataProcessor<EntityPlayerMP, Boolean, Value<Boolean>, AffectsSpawningData, ImmutableAffectsSpawningData> {
    public AffectsSpawningDataProcessor() {
        super(EntityPlayerMP.class, Keys.AFFECTS_SPAWNING);
    }

    @Override
    protected boolean set(EntityPlayerMP entity, Boolean value) {
        ((IMixinEntityPlayer)entity).setAffectsSpawning(value);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(EntityPlayerMP entity) {
        return Optional.of(((IMixinEntityPlayer)entity).affectsSpawning());
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.AFFECTS_SPAWNING, true, value);
    }

    @Override
    protected AffectsSpawningData createManipulator() {
        return new SpongeAffectsSpawningData();
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.AFFECTS_SPAWNING, true, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

