/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.interfaces.command.IMixinCommandSourceName;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;

public class SpongeProxySource
implements ProxySource,
IMixinCommandSourceName {
    final ICommandSender minecraft;
    private final CommandSource messageSource;
    private MessageChannel channel = MessageChannel.TO_ALL;
    private final Subject subjectDelegate;

    public SpongeProxySource(ICommandSender minecraft, CommandSource messageSource, Subject subjectDelegate) {
        this.minecraft = minecraft;
        this.messageSource = messageSource;
        this.subjectDelegate = subjectDelegate;
    }

    @Override
    public CommandSource getOriginalSource() {
        return this.messageSource;
    }

    @Override
    public String getIdentifier() {
        return this.subjectDelegate.getIdentifier();
    }

    @Override
    public ICommandSender asICommandSender() {
        return this.minecraft;
    }

    @Override
    public Set<Context> getActiveContexts() {
        return this.subjectDelegate.getActiveContexts();
    }

    @Override
    public void sendMessage(Text message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        this.minecraft.func_145747_a(SpongeTexts.toComponent(message));
    }

    @Override
    public MessageChannel getMessageChannel() {
        return this.channel;
    }

    @Override
    public void setMessageChannel(MessageChannel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.channel = channel;
    }

    @Override
    public Locale getLocale() {
        return this.messageSource.getLocale();
    }

    @Override
    public Optional<CommandSource> getCommandSource() {
        return Optional.of(this);
    }

    @Override
    public SubjectReference asSubjectReference() {
        return this.subjectDelegate.asSubjectReference();
    }

    @Override
    public SubjectCollection getContainingCollection() {
        return this.subjectDelegate.getContainingCollection();
    }

    @Override
    public boolean isSubjectDataPersisted() {
        return this.subjectDelegate.isSubjectDataPersisted();
    }

    @Override
    public SubjectData getSubjectData() {
        return this.subjectDelegate.getSubjectData();
    }

    @Override
    public SubjectData getTransientSubjectData() {
        return this.subjectDelegate.getTransientSubjectData();
    }

    @Override
    public boolean hasPermission(Set<Context> contexts, String permission) {
        return this.subjectDelegate.hasPermission(contexts, permission);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.subjectDelegate.hasPermission(permission);
    }

    @Override
    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        return this.subjectDelegate.getPermissionValue(contexts, permission);
    }

    @Override
    public boolean isChildOf(SubjectReference parent) {
        return this.subjectDelegate.isChildOf(parent);
    }

    @Override
    public boolean isChildOf(Set<Context> contexts, SubjectReference parent) {
        return this.subjectDelegate.isChildOf(contexts, parent);
    }

    @Override
    public List<SubjectReference> getParents() {
        return this.subjectDelegate.getParents();
    }

    @Override
    public List<SubjectReference> getParents(Set<Context> contexts) {
        return this.subjectDelegate.getParents(contexts);
    }

    @Override
    public Optional<String> getOption(Set<Context> contexts, String key) {
        return this.subjectDelegate.getOption(contexts, key);
    }

    @Override
    public Optional<String> getOption(String key) {
        return this.subjectDelegate.getOption(key);
    }

    public static final class Located
    extends SpongeProxySource
    implements Locatable {
        public Located(ICommandSender mixin, CommandSource messageSource, Subject subjectDelegate) {
            super(mixin, messageSource, subjectDelegate);
        }

        @Override
        public Location<World> getLocation() {
            return new Location<World>((World)this.minecraft.func_130014_f_(), VecHelper.toVector3d(this.minecraft.func_174791_d()));
        }

        @Override
        public World getWorld() {
            return (World)this.minecraft.func_130014_f_();
        }
    }
}

