/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.common.util.VecHelper;

public final class BlockUtil {
    public static final Comparator<BlockState> BLOCK_STATE_COMPARATOR = new BlockStateComparator();
    public static final UUID INVALID_WORLD_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static boolean setBlockState(World world, int x, int y, int z, BlockState state, boolean notifyNeighbors) {
        return BlockUtil.setBlockState(world, new BlockPos(x, y, z), state, notifyNeighbors);
    }

    public static boolean setBlockState(World world, BlockPos position, BlockState state, boolean notifyNeighbors) {
        return world.func_180501_a(position, BlockUtil.toNative(state), notifyNeighbors ? 3 : 2);
    }

    public static boolean setBlockState(Chunk chunk, int x, int y, int z, BlockState state, boolean notifyNeighbors) {
        return BlockUtil.setBlockState(chunk, new BlockPos(x, y, z), state, notifyNeighbors);
    }

    public static boolean setBlockState(Chunk chunk, BlockPos position, BlockState state, boolean notifyNeighbors) {
        if (notifyNeighbors) {
            return BlockUtil.setBlockState(chunk.func_177412_p(), position, state, true);
        }
        return chunk.func_177436_a(position, BlockUtil.toNative(state)) != null;
    }

    public static IBlockState toNative(BlockState state) {
        if (state instanceof IBlockState) {
            return (IBlockState)state;
        }
        throw new UnsupportedOperationException("Custom BlockState implementations are not supported");
    }

    public static BlockState fromNative(IBlockState blockState) {
        if (blockState instanceof BlockState) {
            return (BlockState)blockState;
        }
        throw new UnsupportedOperationException("Custom BlockState implementations are not supported");
    }

    public static BlockType toBlock(IBlockState state) {
        return BlockUtil.fromNative(state).getType();
    }

    public static Block toBlock(BlockState state) {
        return BlockUtil.toNative(state).func_177230_c();
    }

    public static IBlockState getBlockState(org.spongepowered.api.world.World world, Vector3i blockPos) {
        if (!(world instanceof World)) {
            throw new IllegalArgumentException("World : " + world.getName() + " is not appropriate for this implementation!");
        }
        return ((World)world).func_180495_p(VecHelper.toBlockPos(blockPos));
    }

    private BlockUtil() {
    }

    private static final class BlockStateComparator
    implements Comparator<BlockState> {
        BlockStateComparator() {
        }

        @Override
        public int compare(BlockState spongeA, BlockState spongeB) {
            int onRight;
            IBlockState a = (IBlockState)spongeA;
            IBlockState b = (IBlockState)spongeB;
            ComparisonChain chain = ComparisonChain.start();
            chain = chain.compare((Comparable)((Object)a.func_177230_c().func_149739_a()), (Comparable)((Object)b.func_177230_c().func_149739_a()));
            Map<BlockTrait<?>, ?> aTraits = spongeA.getTraitMap();
            Map<BlockTrait<?>, ?> bTraits = spongeA.getTraitMap();
            if ((chain = chain.compare(aTraits.size(), bTraits.size())).result() != 0) {
                return chain.result();
            }
            MapDifference diff = Maps.difference(aTraits, bTraits);
            if (diff.areEqual()) {
                return chain.result();
            }
            int onLeft = diff.entriesOnlyOnLeft().size();
            if ((chain = chain.compare(onLeft, onRight = diff.entriesOnlyOnRight().size())).result() != 0) {
                return chain.result();
            }
            List<BlockTrait<?>> checkOrder = this.sortTraits(diff.entriesDiffering().keySet());
            for (BlockTrait<?> trait : checkOrder) {
                Comparable bTraitValue;
                Comparable aTraitValue = (Comparable)aTraits.get(trait);
                if ((chain = chain.compare(aTraitValue, bTraitValue = (Comparable)bTraits.get(trait))).result() == 0) continue;
                return chain.result();
            }
            throw new IllegalStateException("Some object's equals() violates contract!");
        }

        private List<BlockTrait<?>> sortTraits(Set<BlockTrait<?>> traits) {
            return traits.stream().sorted((a, b) -> a.getId().compareTo(b.getId())).collect(Collectors.toList());
        }
    }
}

