/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;

@Singleton
public class SpongePlatform
implements Platform {
    private final PluginContainer api;
    private final PluginContainer impl;
    private final PluginContainer minecraft;
    private final MinecraftVersion minecraftVersion;
    protected final Map<String, Object> platformMap = new HashMap<String, Object>(){
        private static final long serialVersionUID = 7022397614988467398L;

        @Override
        public Object put(String key, Object value) {
            Preconditions.checkArgument((!this.containsKey(key) ? 1 : 0) != 0, (String)"Cannot set the value of the existing key %s", (Object)key);
            return super.put(key, value);
        }
    };

    @Inject
    public SpongePlatform(PluginManager manager, MinecraftVersion minecraftVersion) {
        this(manager, manager.getPlugin("sponge").get(), minecraftVersion);
    }

    protected SpongePlatform(PluginManager manager, PluginContainer impl, MinecraftVersion minecraftVersion) {
        this.api = manager.getPlugin("spongeapi").get();
        this.impl = (PluginContainer)Preconditions.checkNotNull((Object)impl, (Object)"impl");
        this.minecraft = manager.getPlugin("minecraft").get();
        this.minecraftVersion = (MinecraftVersion)Preconditions.checkNotNull((Object)minecraftVersion, (Object)"minecraftVersion");
        this.platformMap.put("Type", (Object)this.getType());
        this.platformMap.put("ApiName", this.api.getName());
        this.platformMap.put("ApiVersion", this.api.getVersion());
        this.platformMap.put("ImplementationName", this.impl.getName());
        this.platformMap.put("ImplementationVersion", this.impl.getVersion());
        this.platformMap.put("MinecraftVersion", this.getMinecraftVersion());
    }

    @Override
    public Platform.Type getType() {
        return Platform.Type.SERVER;
    }

    @Override
    public Platform.Type getExecutionType() {
        return Platform.Type.SERVER;
    }

    @Override
    public PluginContainer getContainer(Platform.Component component) {
        switch (component) {
            case API: {
                return this.api;
            }
            case IMPLEMENTATION: {
                return this.impl;
            }
            case GAME: {
                return this.minecraft;
            }
        }
        throw new AssertionError((Object)("Unknown platform component: " + (Object)((Object)component)));
    }

    @Override
    public final MinecraftVersion getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    public final Map<String, Object> asMap() {
        return this.platformMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("executionType", (Object)this.getExecutionType()).add("api", (Object)this.api).add("impl", (Object)this.impl).add("minecraftVersion", (Object)this.getMinecraftVersion()).toString();
    }
}

