/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import com.google.common.base.MoreObjects;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.util.weighted.WeightedObject;

public class WeightedSerializableObject<T extends DataSerializable>
extends WeightedObject<T>
implements DataSerializable {
    public WeightedSerializableObject(T object, int weight) {
        super(object, weight);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("object", this.get()).add("weight", this.getWeight()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeightedSerializableObject)) {
            return false;
        }
        WeightedSerializableObject object = (WeightedSerializableObject)o;
        return ((DataSerializable)this.get()).equals(object.get()) && this.getWeight() == object.getWeight();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.WEIGHTED_SERIALIZABLE, this.get()).set(Queries.WEIGHTED_SERIALIZABLE_WEIGHT, (Object)this.getWeight());
    }
}

