/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.plugin.meta.PluginDependency;

public interface PluginContainer {
    public String getId();

    default public String getName() {
        return this.getId();
    }

    default public Optional<String> getVersion() {
        return Optional.empty();
    }

    default public Optional<String> getDescription() {
        return Optional.empty();
    }

    default public Optional<String> getUrl() {
        return Optional.empty();
    }

    default public List<String> getAuthors() {
        return ImmutableList.of();
    }

    default public Set<PluginDependency> getDependencies() {
        return ImmutableSet.of();
    }

    default public Optional<PluginDependency> getDependency(String id) {
        return Optional.empty();
    }

    default public Optional<Asset> getAsset(String name) {
        return Sponge.getAssetManager().getAsset(this, name);
    }

    default public Optional<Path> getSource() {
        return Optional.empty();
    }

    default public Optional<?> getInstance() {
        return Optional.empty();
    }

    default public Logger getLogger() {
        return LoggerFactory.getLogger(this.getId());
    }
}

