/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.smelting;

import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.smelting.SmeltingResult;
import org.spongepowered.api.util.ResettableBuilder;

public interface SmeltingRecipe
extends Recipe {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public ItemStackSnapshot getExemplaryIngredient();

    public boolean isValid(ItemStackSnapshot var1);

    public Optional<SmeltingResult> getResult(ItemStackSnapshot var1);

    public static interface Builder
    extends ResettableBuilder<SmeltingRecipe, Builder> {
        public ResultStep ingredient(Predicate<ItemStackSnapshot> var1, ItemStackSnapshot var2);

        public ResultStep ingredient(ItemStackSnapshot var1);

        default public ResultStep ingredient(ItemStack ingredient) {
            return this.ingredient(ingredient.createSnapshot());
        }

        default public ResultStep ingredient(ItemType ingredient) {
            return this.ingredient(itemStackSnapshot -> itemStackSnapshot.getType() == ingredient, ingredient.getTemplate());
        }

        public static interface EndStep
        extends Builder {
            public EndStep experience(double var1);

            public SmeltingRecipe build();
        }

        public static interface ResultStep
        extends Builder {
            public EndStep result(ItemStackSnapshot var1);

            default public EndStep result(ItemStack result) {
                return this.result(result.createSnapshot());
            }
        }
    }
}

