/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args.parsing;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.parsing.InputTokenizer;
import org.spongepowered.api.command.args.parsing.SingleArg;

class SpaceSplitInputTokenizer
implements InputTokenizer {
    public static final SpaceSplitInputTokenizer INSTANCE = new SpaceSplitInputTokenizer();

    private SpaceSplitInputTokenizer() {
    }

    @Override
    public List<SingleArg> tokenize(String arguments, boolean lenient) throws ArgumentParseException {
        int spaceIndex;
        ArrayList<SingleArg> ret = new ArrayList<SingleArg>();
        int lastIndex = 0;
        while ((spaceIndex = arguments.indexOf(" ")) != -1) {
            arguments = arguments.substring(0, spaceIndex);
            ret.add(new SingleArg(arguments, lastIndex, lastIndex + spaceIndex));
            lastIndex += spaceIndex + 1;
        }
        return ret;
    }
}

