/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.advancement;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.AdvancementType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.ResettableBuilder;

public interface DisplayInfo {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public AdvancementType getType();

    public Text getDescription();

    public ItemStackSnapshot getIcon();

    public Text getTitle();

    public boolean doesShowToast();

    public boolean doesAnnounceToChat();

    public boolean isHidden();

    public static interface Builder
    extends ResettableBuilder<DisplayInfo, Builder> {
        public Builder type(AdvancementType var1);

        public Builder description(Text var1);

        public Builder title(Text var1);

        default public Builder icon(ItemType itemType) {
            return this.icon(ItemStack.of(itemType, 1));
        }

        default public Builder icon(ItemStack itemStack) {
            return this.icon(itemStack.createSnapshot());
        }

        public Builder icon(ItemStackSnapshot var1);

        public Builder showToast(boolean var1);

        public Builder announceToChat(boolean var1);

        public Builder hidden(boolean var1);

        public DisplayInfo build();
    }
}

