/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate;

import com.google.common.base.Objects;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import ninja.leaping.configurate.ConfigValue;
import ninja.leaping.configurate.SimpleConfigurationNode;

class MapConfigValue
extends ConfigValue {
    volatile ConcurrentMap<Object, SimpleConfigurationNode> values = this.newMap();

    public MapConfigValue(SimpleConfigurationNode holder) {
        super(holder);
    }

    @Override
    public Object getValue() {
        LinkedHashMap value = new LinkedHashMap();
        for (Map.Entry ent : this.values.entrySet()) {
            value.put(ent.getKey(), ((SimpleConfigurationNode)ent.getValue()).getValue());
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) {
        if (value instanceof Map) {
            ConcurrentMap<Object, SimpleConfigurationNode> newValue = this.newMap();
            for (Map.Entry ent : ((Map)value).entrySet()) {
                if (ent.getValue() == null) continue;
                SimpleConfigurationNode child = this.holder.createNode(ent.getKey());
                newValue.put(ent.getKey(), child);
                child.attached = true;
                child.setValue(ent.getValue());
            }
            MapConfigValue mapConfigValue = this;
            synchronized (mapConfigValue) {
                ConcurrentMap<Object, SimpleConfigurationNode> oldMap = this.values;
                this.values = newValue;
                this.detachChildren(oldMap);
            }
        } else {
            throw new IllegalArgumentException("Map configuration values can only be set to values of type Map");
        }
    }

    @Override
    SimpleConfigurationNode putChild(Object key, SimpleConfigurationNode value) {
        if (value == null) {
            return (SimpleConfigurationNode)this.values.remove(key);
        }
        return this.values.put(key, value);
    }

    @Override
    SimpleConfigurationNode putChildIfAbsent(Object key, SimpleConfigurationNode value) {
        if (value == null) {
            return (SimpleConfigurationNode)this.values.remove(key);
        }
        return this.values.putIfAbsent(key, value);
    }

    @Override
    public SimpleConfigurationNode getChild(Object key) {
        return (SimpleConfigurationNode)this.values.get(key);
    }

    @Override
    public Iterable<SimpleConfigurationNode> iterateChildren() {
        return this.values.values();
    }

    private void detachChildren(Map<Object, SimpleConfigurationNode> map) {
        for (SimpleConfigurationNode value : map.values()) {
            value.attached = false;
            value.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MapConfigValue mapConfigValue = this;
        synchronized (mapConfigValue) {
            ConcurrentMap<Object, SimpleConfigurationNode> oldMap = this.values;
            this.values = this.newMap();
            this.detachChildren(oldMap);
        }
    }

    private ConcurrentMap<Object, SimpleConfigurationNode> newMap() {
        return this.holder.getOptions().getMapFactory().create();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapConfigValue that = (MapConfigValue)o;
        return Objects.equal(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.values});
    }
}

