/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.world.gen;

import co.aikar.timings.SpongeTimingsFactory;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.StoneType;
import org.spongepowered.api.data.type.StoneTypes;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.PopulateChunkEvent;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.gen.BiomeGenerator;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.populator.BigMushroom;
import org.spongepowered.api.world.gen.populator.Cactus;
import org.spongepowered.api.world.gen.populator.DeadBush;
import org.spongepowered.api.world.gen.populator.Dungeon;
import org.spongepowered.api.world.gen.populator.Flower;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.populator.Fossil;
import org.spongepowered.api.world.gen.populator.Glowstone;
import org.spongepowered.api.world.gen.populator.Lake;
import org.spongepowered.api.world.gen.populator.Mushroom;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.api.world.gen.populator.Pumpkin;
import org.spongepowered.api.world.gen.populator.RandomBlock;
import org.spongepowered.api.world.gen.populator.Reed;
import org.spongepowered.api.world.gen.populator.SeaFloor;
import org.spongepowered.api.world.gen.populator.Shrub;
import org.spongepowered.api.world.gen.populator.WaterLily;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.PopulatorPhaseContext;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IFlaggedPopulator;
import org.spongepowered.common.interfaces.world.gen.IGenerationPopulator;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.extent.SoftBufferExtentViewDownsize;
import org.spongepowered.common.world.gen.SpongeChunkGenerator;
import org.spongepowered.common.world.gen.SpongeGenerationPopulator;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.gen.populators.AnimalPopulator;
import org.spongepowered.common.world.gen.populators.SnowPopulator;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

public final class SpongeChunkGeneratorForge
extends SpongeChunkGenerator {
    public SpongeChunkGeneratorForge(net.minecraft.world.World world, GenerationPopulator generationPopulator, BiomeGenerator biomeGenerator) {
        super(world, generationPopulator, biomeGenerator);
        String chunkGeneratorName = "";
        String modId = StaticMixinForgeHelper.getModIdFromClass(generationPopulator.getClass());
        chunkGeneratorName = modId.equalsIgnoreCase("unknown") ? (generationPopulator instanceof SpongeGenerationPopulator ? "chunkGenerator (" + ((SpongeGenerationPopulator)generationPopulator).getHandle(world).getClass().getSimpleName() + ")" : "chunkGenerator (" + generationPopulator.getClass().getName() + ")") : "chunkGenerator (" + modId + ":" + generationPopulator.getClass().getSimpleName().toLowerCase() + ")";
        this.chunkGeneratorTiming = SpongeTimingsFactory.ofSafe(chunkGeneratorName, ((IMixinWorldServer)world).getTimingsHandler().chunkPopulate);
    }

    @Override
    public void replaceBiomeBlocks(net.minecraft.world.World world, Random rand, int x, int z, ChunkPrimer chunk, ImmutableBiomeVolume biomes) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks((IChunkGenerator)this, x, z, chunk, world);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        super.replaceBiomeBlocks(world, rand, x, z, chunk, biomes);
    }

    @Override
    public void func_185931_b(int chunkX, int chunkZ) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        this.chunkGeneratorTiming.startTimingIfSync();
        this.rand.setSeed(this.world.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.world.func_72905_C());
        BlockFalling.field_149832_M = true;
        this.cachedBiomes.reuse(new Vector3i(chunkX * 16, 0, chunkZ * 16));
        this.biomeGenerator.generateBiomes(this.cachedBiomes);
        ImmutableBiomeVolume biomeBuffer = this.cachedBiomes.getImmutableBiomeCopy();
        BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BiomeType biome = (BiomeType)this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        Chunk chunk = (Chunk)this.world.func_72964_e(chunkX, chunkZ);
        BiomeGenerationSettings settings = this.getBiomeSettings(biome);
        ArrayList<Populator> populators = new ArrayList<Populator>(this.pop);
        Populator snowPopulator = null;
        Iterator itr = populators.iterator();
        while (itr.hasNext()) {
            Populator populator = (Populator)itr.next();
            if (!(populator instanceof SnowPopulator)) continue;
            itr.remove();
            snowPopulator = populator;
            break;
        }
        populators.addAll(settings.getPopulators());
        if (snowPopulator != null) {
            populators.add(snowPopulator);
        }
        Sponge.getGame().getEventManager().post(SpongeEventFactory.createPopulateChunkEventPre(Sponge.getCauseStackManager().getCurrentCause(), populators, chunk));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, false));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, blockpos));
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(this.world, this.rand, blockpos));
        ArrayList flags = Lists.newArrayList();
        Vector3i min = new Vector3i(chunkX * 16 + 8, 0, chunkZ * 16 + 8);
        World spongeWorld = (World)this.world;
        SoftBufferExtentViewDownsize volume = new SoftBufferExtentViewDownsize(chunk.getWorld(), min, min.add(15, 255, 15), min.sub(8, 0, 8), min.add(23, 255, 23));
        for (Populator populator : populators) {
            if (!this.checkForgeEvent(populator, this, chunkX, chunkZ, flags, chunk)) continue;
            PopulatorType type = populator.getType();
            if (type == null) {
                System.err.printf("Found a populator with a null type: %s populator%n", populator);
            }
            if (Sponge.getGame().getEventManager().post(SpongeEventFactory.createPopulateChunkEventPopulate(Sponge.getCauseStackManager().getCurrentCause(), populator, chunk))) continue;
            PopulatorPhaseContext context = (PopulatorPhaseContext)((PopulatorPhaseContext)GenerationPhase.State.POPULATOR_RUNNING.createPhaseContext().world(this.world)).populator(type).buildAndSwitch();
            Throwable throwable = null;
            try {
                Timing timing = null;
                if (Timings.isTimingsEnabled()) {
                    timing = (Timing)this.populatorTimings.get(populator.getType().getId());
                    if (timing == null) {
                        timing = SpongeTimingsFactory.ofSafe(populator.getType().getId());
                        this.populatorTimings.put(populator.getType().getId(), timing);
                    }
                    timing.startTimingIfSync();
                }
                if (populator instanceof IFlaggedPopulator) {
                    ((IFlaggedPopulator)populator).populate(spongeWorld, volume, this.rand, biomeBuffer, flags);
                } else {
                    populator.populate(spongeWorld, volume, this.rand, biomeBuffer);
                }
                if (!Timings.isTimingsEnabled()) continue;
                timing.stopTimingIfSync();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (context == null) continue;
                if (throwable != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                context.close();
            }
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.world, this.rand, blockpos));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, blockpos));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, false));
        if (this.baseGenerator instanceof SpongeGenerationPopulator) {
            Timing timing = null;
            IChunkGenerator chunkGenerator = ((SpongeGenerationPopulator)this.baseGenerator).getHandle(this.world);
            if (Timings.isTimingsEnabled()) {
                IGenerationPopulator spongePopulator = (IGenerationPopulator)((Object)this.baseGenerator);
                timing = spongePopulator.getTimingsHandler();
                timing.startTimingIfSync();
            }
            chunkGenerator.func_185931_b(chunkX, chunkZ);
            if (Timings.isTimingsEnabled()) {
                timing.stopTimingIfSync();
            }
        }
        PopulateChunkEvent.Post event = SpongeEventFactory.createPopulateChunkEventPost(Sponge.getCauseStackManager().getCurrentCause(), (List)ImmutableList.copyOf(populators), chunk);
        SpongeImpl.postEvent(event);
        BlockFalling.field_149832_M = false;
        this.chunkGeneratorTiming.stopTimingIfSync();
        ((IMixinWorldServer)((Object)spongeWorld)).getTimingsHandler().chunkPopulate.stopTimingIfSync();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkForgeEvent(Populator populator, IChunkGenerator chunkProvider, int chunkX, int chunkZ, List<String> flags, Chunk chunk) {
        boolean village_flag = flags.contains("VILLAGE");
        if (populator instanceof Ore && populator instanceof WorldGenerator) {
            BlockType type = ((Ore)populator).getOreBlock().getType();
            OreGenEvent.GenerateMinable.EventType otype = null;
            if (type.equals(BlockTypes.DIRT)) {
                otype = OreGenEvent.GenerateMinable.EventType.DIRT;
            } else if (type.equals(BlockTypes.GRAVEL)) {
                otype = OreGenEvent.GenerateMinable.EventType.GRAVEL;
            } else if (type.equals(BlockTypes.STONE)) {
                BlockState state = ((Ore)populator).getOreBlock();
                Optional<StoneType> stype = state.get(Keys.STONE_TYPE);
                if (stype.isPresent()) {
                    StoneType stoneType = stype.get();
                    if (stoneType.equals(StoneTypes.DIORITE)) {
                        otype = OreGenEvent.GenerateMinable.EventType.DIORITE;
                    } else if (stoneType.equals(StoneTypes.ANDESITE)) {
                        otype = OreGenEvent.GenerateMinable.EventType.ANDESITE;
                    } else {
                        if (!stoneType.equals(StoneTypes.GRANITE)) return true;
                        otype = OreGenEvent.GenerateMinable.EventType.GRANITE;
                    }
                }
            } else if (type.equals(BlockTypes.COAL_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.COAL;
            } else if (type.equals(BlockTypes.IRON_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.IRON;
            } else if (type.equals(BlockTypes.GOLD_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.GOLD;
            } else if (type.equals(BlockTypes.REDSTONE_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.REDSTONE;
            } else if (type.equals(BlockTypes.DIAMOND_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.DIAMOND;
            } else if (type.equals(BlockTypes.LAPIS_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.LAPIS;
            } else if (type.equals(BlockTypes.QUARTZ_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.QUARTZ;
            } else if (type.equals(BlockTypes.EMERALD_ORE)) {
                otype = OreGenEvent.GenerateMinable.EventType.EMERALD;
            } else if (type.equals(BlockTypes.MONSTER_EGG)) {
                otype = OreGenEvent.GenerateMinable.EventType.SILVERFISH;
            }
            if (otype == null) return true;
            return TerrainGen.generateOre((net.minecraft.world.World)((net.minecraft.world.World)chunk.getWorld()), (Random)this.rand, (WorldGenerator)((WorldGenerator)populator), (BlockPos)VecHelper.toBlockPos(chunk.getBlockMin()), (OreGenEvent.GenerateMinable.EventType)otype);
        }
        PopulateChunkEvent.Populate.EventType etype = this.getForgeEventTypeForPopulator(populator, chunk);
        if (etype != null) {
            return TerrainGen.populate((IChunkGenerator)chunkProvider, (net.minecraft.world.World)((net.minecraft.world.World)chunk.getWorld()), (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)village_flag, (PopulateChunkEvent.Populate.EventType)etype);
        }
        DecorateBiomeEvent.Decorate.EventType detype = this.getForgeDecorateEventTypeForPopulator(populator, chunk);
        if (detype == null) return true;
        return TerrainGen.decorate((net.minecraft.world.World)((net.minecraft.world.World)chunk.getWorld()), (Random)this.rand, (BlockPos)VecHelper.toBlockPos(chunk.getBlockMin()), (DecorateBiomeEvent.Decorate.EventType)detype);
    }

    private PopulateChunkEvent.Populate.EventType getForgeEventTypeForPopulator(Populator populator, Chunk chunk) {
        if (populator instanceof Lake) {
            if (((Lake)populator).getLiquidType().getType().equals(BlockTypes.LAVA) || ((Lake)populator).getLiquidType().getType().equals(BlockTypes.FLOWING_LAVA)) {
                return PopulateChunkEvent.Populate.EventType.LAVA;
            }
            return PopulateChunkEvent.Populate.EventType.LAKE;
        }
        if (populator instanceof Dungeon) {
            return PopulateChunkEvent.Populate.EventType.DUNGEON;
        }
        if (populator instanceof AnimalPopulator) {
            return PopulateChunkEvent.Populate.EventType.ANIMALS;
        }
        if (populator instanceof SnowPopulator) {
            return PopulateChunkEvent.Populate.EventType.ICE;
        }
        if (populator instanceof Glowstone) {
            return PopulateChunkEvent.Populate.EventType.GLOWSTONE;
        }
        if (populator instanceof RandomBlock) {
            BlockType type = ((RandomBlock)populator).getBlock().getType();
            if (type.equals(BlockTypes.FLOWING_LAVA) || type.equals(BlockTypes.LAVA)) {
                if (chunk.getWorld().getProperties().getGeneratorType().equals(GeneratorTypes.NETHER)) {
                    if (((RandomBlock)populator).getPlacementTarget().equals(WorldGenConstants.HELL_LAVA_ENCLOSED)) {
                        return PopulateChunkEvent.Populate.EventType.NETHER_LAVA2;
                    }
                    return PopulateChunkEvent.Populate.EventType.NETHER_LAVA;
                }
                return null;
            }
            if (type.equals(BlockTypes.FIRE)) {
                if (chunk.getWorld().getProperties().getGeneratorType().equals(GeneratorTypes.NETHER)) {
                    return PopulateChunkEvent.Populate.EventType.FIRE;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private DecorateBiomeEvent.Decorate.EventType getForgeDecorateEventTypeForPopulator(Populator populator, Chunk chunk) {
        BlockType type;
        if (populator instanceof SeaFloor) {
            type = ((SeaFloor)populator).getBlock().getType();
            if (type.equals(BlockTypes.SAND)) {
                return DecorateBiomeEvent.Decorate.EventType.SAND;
            }
            if (type.equals(BlockTypes.CLAY)) {
                return DecorateBiomeEvent.Decorate.EventType.CLAY;
            }
            if (type.equals(BlockTypes.GRAVEL)) {
                return DecorateBiomeEvent.Decorate.EventType.SAND_PASS2;
            }
        }
        if (populator instanceof Forest) {
            return DecorateBiomeEvent.Decorate.EventType.TREE;
        }
        if (populator instanceof BigMushroom) {
            return DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM;
        }
        if (populator instanceof Flower) {
            return DecorateBiomeEvent.Decorate.EventType.FLOWERS;
        }
        if (populator instanceof Shrub) {
            return DecorateBiomeEvent.Decorate.EventType.TREE;
        }
        if (populator instanceof DeadBush) {
            return DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH;
        }
        if (populator instanceof WaterLily) {
            return DecorateBiomeEvent.Decorate.EventType.LILYPAD;
        }
        if (populator instanceof Mushroom) {
            return DecorateBiomeEvent.Decorate.EventType.SHROOM;
        }
        if (populator instanceof Reed) {
            return DecorateBiomeEvent.Decorate.EventType.REED;
        }
        if (populator instanceof Pumpkin) {
            return DecorateBiomeEvent.Decorate.EventType.PUMPKIN;
        }
        if (populator instanceof Cactus) {
            return DecorateBiomeEvent.Decorate.EventType.CACTUS;
        }
        if (populator instanceof RandomBlock) {
            type = ((RandomBlock)populator).getBlock().getType();
            if (type.equals(BlockTypes.FLOWING_WATER) || type.equals(BlockTypes.WATER)) {
                return DecorateBiomeEvent.Decorate.EventType.LAKE_WATER;
            }
            if (type.equals(BlockTypes.FLOWING_LAVA) || type.equals(BlockTypes.LAVA)) {
                if (chunk.getWorld().getProperties().getGeneratorType().equals(GeneratorTypes.NETHER)) {
                    return null;
                }
                return DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA;
            }
            return null;
        }
        if (populator instanceof Fossil) {
            return DecorateBiomeEvent.Decorate.EventType.FOSSIL;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("World", (Object)this.world).toString();
    }
}

