/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.registry.type.entity.CareerRegistryModule;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;
import org.spongepowered.mod.interfaces.IMixinVillagerCareer;

public class SpongeForgeVillagerRegistry {
    private static final BiMap<VillagerRegistry.VillagerProfession, Profession> professionMap = HashBiMap.create();
    private static final BiMap<VillagerRegistry.VillagerCareer, Career> careerMap = HashBiMap.create();
    private static final BiMap<String, Profession> forgeToSpongeProfessionMap = HashBiMap.create();
    private static final BiMap<String, Career> forgeToSpongeCareerMap = HashBiMap.create();

    public static SpongeProfession validateProfession(VillagerRegistry.VillagerProfession villagerProfession, SpongeProfession profession) {
        SpongeProfession spongeProfession = (SpongeProfession)forgeToSpongeProfessionMap.get((Object)villagerProfession.getRegistryName().toString());
        if (spongeProfession != null) {
            professionMap.put((Object)villagerProfession, (Object)spongeProfession);
        } else {
            professionMap.put((Object)villagerProfession, (Object)profession);
        }
        return spongeProfession != null ? spongeProfession : profession;
    }

    public static SpongeCareer validateCareer(VillagerRegistry.VillagerCareer villagerCareer, Career career) {
        Career spongeCareer = (Career)forgeToSpongeCareerMap.get((Object)villagerCareer.getName());
        if (spongeCareer != null) {
            careerMap.put((Object)villagerCareer, (Object)spongeCareer);
        } else {
            careerMap.put((Object)villagerCareer, (Object)career);
            if (((IMixinVillagerCareer)villagerCareer).isDelayed()) {
                ((IMixinVillagerCareer)villagerCareer).performDelayedInit();
            }
        }
        return spongeCareer == null ? (SpongeCareer)career : (SpongeCareer)spongeCareer;
    }

    public static Optional<Profession> getProfession(VillagerRegistry.VillagerProfession profession) {
        return Optional.ofNullable(professionMap.get((Object)profession));
    }

    public static Optional<VillagerRegistry.VillagerProfession> getProfession(Profession profession) {
        return Optional.ofNullable(professionMap.inverse().get((Object)profession));
    }

    public static Optional<SpongeCareer> fromNative(VillagerRegistry.VillagerCareer career) {
        return Optional.ofNullable((SpongeCareer)careerMap.get((Object)career));
    }

    public static Optional<SpongeProfession> fromNative(VillagerRegistry.VillagerProfession profession) {
        return Optional.ofNullable((SpongeProfession)professionMap.get((Object)profession));
    }

    public static void registerForgeCareer(VillagerRegistry.VillagerCareer career) {
        VillagerRegistry.VillagerProfession villagerProfession = ((IMixinVillagerCareer)career).getProfession();
        Optional<Profession> spongeProfession = SpongeForgeVillagerRegistry.getProfession(villagerProfession);
        spongeProfession.ifPresent(profession -> {
            SpongeCareer suggestedCareer = new SpongeCareer(((IMixinVillagerCareer)career).getId(), career.getName(), (Profession)profession, new SpongeTranslation("entity.Villager." + career.getName()));
            SpongeCareer registeredCareer = SpongeForgeVillagerRegistry.validateCareer(career, suggestedCareer);
            CareerRegistryModule.getInstance().registerCareer(registeredCareer);
        });
        if (!spongeProfession.isPresent()) {
            SpongeImpl.getLogger().debug("Delaying registration of career {} until its profession {} is registered with Forge.", (Object)career.getName(), (Object)villagerProfession.getRegistryName());
        }
    }

    static {
        forgeToSpongeProfessionMap.put((Object)"minecraft:smith", (Object)ProfessionRegistryModule.BLACKSMITH);
        forgeToSpongeCareerMap.put((Object)"leather", (Object)CareerRegistryModule.getInstance().LEATHERWORKER);
        forgeToSpongeCareerMap.put((Object)"armor", (Object)CareerRegistryModule.getInstance().ARMORER);
        forgeToSpongeCareerMap.put((Object)"tool", (Object)CareerRegistryModule.getInstance().TOOL_SMITH);
        forgeToSpongeCareerMap.put((Object)"weapon", (Object)CareerRegistryModule.getInstance().WEAPON_SMITH);
    }
}

