/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.worker.BiomeVolumeWorker;
import org.spongepowered.common.util.gen.AbstractBiomeBuffer;
import org.spongepowered.common.util.gen.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.extent.ImmutableBiomeViewDownsize;
import org.spongepowered.common.world.extent.ImmutableBiomeViewTransform;
import org.spongepowered.common.world.extent.worker.SpongeBiomeVolumeWorker;

public final class ObjectArrayImmutableBiomeBuffer
extends AbstractBiomeBuffer
implements ImmutableBiomeVolume {
    private final BiomeType[] biomes;

    public ObjectArrayImmutableBiomeBuffer(BiomeType[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = (BiomeType[])biomes.clone();
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.biomes[this.getIndex(x, z)];
    }

    public Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        BiomeType type = this.biomes[this.getIndex(x, z)];
        if (type instanceof VirtualBiomeType) {
            type = ((VirtualBiomeType)type).getPersistedType();
        }
        return (Biome)type;
    }

    @Override
    public ImmutableBiomeVolume getBiomeView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new ImmutableBiomeViewDownsize(this, newMin, newMax);
    }

    @Override
    public ImmutableBiomeVolume getBiomeView(DiscreteTransform3 transform) {
        return new ImmutableBiomeViewTransform(this, transform);
    }

    @Override
    public BiomeVolumeWorker<? extends ImmutableBiomeVolume> getBiomeWorker() {
        return new SpongeBiomeVolumeWorker<ObjectArrayImmutableBiomeBuffer>(this);
    }

    @Override
    public MutableBiomeVolume getBiomeCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ObjectArrayMutableBiomeBuffer((BiomeType[])this.biomes.clone(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBiomeVolume getImmutableBiomeCopy() {
        return this;
    }
}

