/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.statistic;

import com.google.common.base.CaseFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.common.interfaces.statistic.IMixinStatBase;

public interface SpongeStatistic
extends Statistic {
    @Override
    default public String getId() {
        String spongeId = this.getSpongeId();
        if (spongeId == null) {
            spongeId = this.getMinecraftId();
            int prefixStop = spongeId.indexOf(".");
            if (prefixStop != -1) {
                spongeId = spongeId.substring(prefixStop + 1);
            }
            spongeId = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, spongeId);
            this.setSpongeId(spongeId);
        }
        return spongeId;
    }

    @Nullable
    public String getSpongeId();

    public void setSpongeId(String var1);

    public String getMinecraftId();

    @Override
    default public NumberFormat getFormat() {
        return ((IMixinStatBase)((Object)this)).format();
    }
}

