/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.chunk.storage;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinAnvilChunkLoader;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.util.QueuedChunk;

@Mixin(value={AnvilChunkLoader.class})
@Implements(value={@Interface(iface=IMixinAnvilChunkLoader.class, prefix="loader$")})
public abstract class MixinAnvilChunkLoader
implements IMixinAnvilChunkLoader {
    private ConcurrentLinkedQueue<QueuedChunk> queue = new ConcurrentLinkedQueue();
    private final Object lock = new Object();
    private static final String ENTITY_LIST_CREATE_FROM_NBT = "Lnet/minecraft/entity/EntityList;createEntityFromNBT(Lnet/minecraft/nbt/NBTTagCompound;Lnet/minecraft/world/World;)Lnet/minecraft/entity/Entity;";
    @Shadow
    @Final
    private static Logger field_151505_a;
    @Shadow
    @Final
    private Map<ChunkPos, NBTTagCompound> field_75828_a;
    @Shadow
    @Final
    private File field_75825_d;
    @Shadow
    private boolean field_183014_e;

    @Shadow
    public abstract void func_183013_b(ChunkPos var1, NBTTagCompound var2);

    @Inject(method={"writeChunkToNBT"}, at={@At(value="RETURN")})
    public void onWriteChunkToNBT(Chunk chunkIn, net.minecraft.world.World worldIn, NBTTagCompound compound, CallbackInfo ci) {
        IMixinChunk chunk = (IMixinChunk)chunkIn;
        if (chunk.getTrackedShortPlayerPositions().size() > 0 || chunk.getTrackedIntPlayerPositions().size() > 0) {
            NBTTagCompound valueNbt;
            Integer notifierUniqueIdIndex;
            Integer ownerUniqueIdIndex;
            Number pos;
            NBTTagCompound trackedNbt = new NBTTagCompound();
            NBTTagList positions = new NBTTagList();
            trackedNbt.func_74782_a("BlockPosTable", (NBTBase)positions);
            compound.func_74782_a("SpongeData", (NBTBase)trackedNbt);
            for (Map.Entry<Short, PlayerTracker> entry : chunk.getTrackedShortPlayerPositions().entrySet()) {
                pos = entry.getKey();
                ownerUniqueIdIndex = entry.getValue().ownerIndex;
                notifierUniqueIdIndex = entry.getValue().notifierIndex;
                valueNbt = new NBTTagCompound();
                valueNbt.func_74768_a("owner", ownerUniqueIdIndex.intValue());
                valueNbt.func_74768_a("notifier", notifierUniqueIdIndex.intValue());
                valueNbt.func_74777_a("pos", ((Short)pos).shortValue());
                positions.func_74742_a((NBTBase)valueNbt);
            }
            for (Map.Entry<Number, PlayerTracker> entry : chunk.getTrackedIntPlayerPositions().entrySet()) {
                pos = (Integer)entry.getKey();
                ownerUniqueIdIndex = entry.getValue().ownerIndex;
                notifierUniqueIdIndex = entry.getValue().notifierIndex;
                valueNbt = new NBTTagCompound();
                valueNbt.func_74768_a("owner", ownerUniqueIdIndex.intValue());
                valueNbt.func_74768_a("notifier", notifierUniqueIdIndex.intValue());
                valueNbt.func_74768_a("ipos", ((Integer)pos).intValue());
                positions.func_74742_a((NBTBase)valueNbt);
            }
        }
    }

    @Inject(method={"readChunkFromNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;getIntArray(Ljava/lang/String;)[I", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onReadChunkFromNBT(net.minecraft.world.World worldIn, NBTTagCompound compound, CallbackInfoReturnable<Chunk> ci, int chunkX, int chunkZ, Chunk chunkIn) {
        if (compound.func_74764_b("SpongeData")) {
            HashMap trackedIntPlayerPositions = Maps.newHashMap();
            HashMap trackedShortPlayerPositions = Maps.newHashMap();
            NBTTagList positions = compound.func_74775_l("SpongeData").func_150295_c("BlockPosTable", 10);
            IMixinChunk chunk = (IMixinChunk)chunkIn;
            for (int i = 0; i < positions.func_74745_c(); ++i) {
                NBTTagCompound valueNbt = positions.func_150305_b(i);
                boolean isShortPos = valueNbt.func_74764_b("pos");
                PlayerTracker tracker = new PlayerTracker();
                if (valueNbt.func_74764_b("owner")) {
                    tracker.ownerIndex = valueNbt.func_74762_e("owner");
                } else if (valueNbt.func_74764_b("uuid")) {
                    tracker.ownerIndex = valueNbt.func_74762_e("uuid");
                }
                if (valueNbt.func_74764_b("notifier")) {
                    tracker.notifierIndex = valueNbt.func_74762_e("notifier");
                }
                if (tracker.notifierIndex == -1 && tracker.ownerIndex == -1) continue;
                if (isShortPos) {
                    trackedShortPlayerPositions.put(valueNbt.func_74765_d("pos"), tracker);
                    continue;
                }
                trackedIntPlayerPositions.put(valueNbt.func_74762_e("ipos"), tracker);
            }
            chunk.setTrackedIntPlayerPositions(trackedIntPlayerPositions);
            chunk.setTrackedShortPlayerPositions(trackedShortPlayerPositions);
        }
    }

    @Redirect(method={"readChunkEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityList;createEntityFromNBT(Lnet/minecraft/nbt/NBTTagCompound;Lnet/minecraft/world/World;)Lnet/minecraft/entity/Entity;"), require=0, expect=0)
    private static Entity onReadChunkEntity(NBTTagCompound compound, net.minecraft.world.World world, Chunk chunk) {
        Class<? extends Entity> entityClass;
        if ("Minecart".equals(compound.func_74779_i("id"))) {
            compound.func_74778_a("id", EntityMinecart.Type.values()[compound.func_74762_e("Type")].func_184954_b());
            compound.func_82580_o("Type");
        }
        if ((entityClass = SpongeImplHooks.getEntityClass(new ResourceLocation(compound.func_74779_i("id")))) == null) {
            return null;
        }
        CatalogType type = EntityTypeRegistryModule.getInstance().getForClass((Class)entityClass);
        if (type == null) {
            return null;
        }
        NBTTagList positionList = compound.func_150295_c("Pos", 6);
        NBTTagList rotationList = compound.func_150295_c("Rotation", 5);
        Vector3d position = new Vector3d(positionList.func_150309_d(0), positionList.func_150309_d(1), positionList.func_150309_d(2));
        Vector3d rotation = new Vector3d(rotationList.func_150308_e(0), rotationList.func_150308_e(1), 0.0f);
        Transform<World> transform = new Transform<World>((World)world, position, rotation);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CHUNK_LOAD);
            ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), (EntityType)type, transform);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                Entity entity = null;
                return entity;
            }
            Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (net.minecraft.world.World)world);
            return entity;
        }
    }

    @Intrinsic
    public boolean loader$chunkExists(net.minecraft.world.World world, int x, int z) {
        ChunkPos chunkcoordintpair = new ChunkPos(x, z);
        if (this.field_75828_a.containsKey(chunkcoordintpair)) {
            return true;
        }
        return RegionFileCache.func_76549_c((File)this.field_75825_d, (int)x, (int)z) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    protected void func_75824_a(ChunkPos pos, NBTTagCompound compound) {
        Object object = this.lock;
        synchronized (object) {
            this.field_75828_a.put(pos, compound);
        }
        this.queue.add(new QueuedChunk(pos, compound));
        ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)((AnvilChunkLoader)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public boolean func_75814_c() {
        QueuedChunk chunk = this.queue.poll();
        if (chunk == null) {
            if (this.field_183014_e) {
                field_151505_a.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", new Object[]{this.field_75825_d.getName()});
            }
            return false;
        }
        ChunkPos chunkpos = chunk.coords;
        NBTTagCompound nbttagcompound = chunk.compound;
        if (nbttagcompound != null) {
            int attempts = 0;
            Throwable laste = null;
            while (attempts++ < 5) {
                try {
                    this.func_183013_b(chunkpos, nbttagcompound);
                    laste = null;
                    break;
                }
                catch (Exception exception) {
                    laste = exception;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (laste != null) {
                laste.printStackTrace();
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.field_75828_a.get(chunkpos) == nbttagcompound) {
                this.field_75828_a.remove(chunkpos);
            }
        }
        boolean lvt_3_1_ = true;
        return lvt_3_1_;
    }

    @Override
    public Path getWorldDir() {
        return this.field_75825_d.toPath();
    }
}

