/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.SlotCollectionIterator;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@NonnullByDefault
@Mixin(value={net.minecraft.inventory.Container.class}, priority=998)
@Implements(value={@Interface(iface=MinecraftInventoryAdapter.class, prefix="inventory$")})
public abstract class MixinContainer
implements Container,
IMixinContainer,
CarriedInventory<Carrier> {
    @Shadow
    public List<net.minecraft.inventory.Slot> field_75151_b;
    @Shadow
    public NonNullList<net.minecraft.item.ItemStack> field_75153_a;
    @Shadow
    public int field_75152_c;
    @Shadow
    protected List<IContainerListener> field_75149_d;
    private boolean spectatorChest;
    private boolean dirty = true;
    private boolean crafting = false;
    @Nullable
    private CraftItemEvent.Craft lastCraft = null;
    private boolean captureInventory = false;
    private boolean shiftCraft = false;
    private List<SlotTransaction> capturedSlotTransactions = new ArrayList<SlotTransaction>();
    private List<SlotTransaction> capturedCraftShiftTransactions = new ArrayList<SlotTransaction>();
    private List<SlotTransaction> capturedCraftPreviewTransactions = new ArrayList<SlotTransaction>();
    private Fabric<IInventory> fabric;
    private SlotProvider<IInventory, net.minecraft.item.ItemStack> slots;
    private Lens<IInventory, net.minecraft.item.ItemStack> lens;
    private boolean initialized;
    private Map<Integer, SlotAdapter> adapters = new HashMap<Integer, SlotAdapter>();
    private InventoryArchetype archetype;
    protected Optional<Carrier> carrier = Optional.empty();
    protected Optional<Predicate<EntityPlayer>> canInteractWithPredicate = Optional.empty();
    @Nullable
    private PluginContainer plugin = null;
    private net.minecraft.item.ItemStack previousCursor;

    @Shadow
    public abstract NonNullList<net.minecraft.item.ItemStack> func_75138_a();

    @Shadow
    public abstract net.minecraft.inventory.Slot func_75139_a(int var1);

    @Shadow
    public net.minecraft.item.ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        throw new IllegalStateException("Shadowed.");
    }

    @Shadow
    protected abstract void func_94533_d();

    private void init() {
        if (this.initialized && !this.dirty) {
            return;
        }
        this.dirty = false;
        this.initialized = true;
        this.adapters.clear();
        this.fabric = MinecraftFabric.of(this);
        this.slots = ContainerUtil.countSlots((net.minecraft.inventory.Container)this, this.fabric);
        this.lens = null;
        this.lens = this.spectatorChest ? null : ContainerUtil.getLens(this.fabric, (net.minecraft.inventory.Container)this, this.slots);
        this.archetype = ContainerUtil.getArchetype((net.minecraft.inventory.Container)this);
        this.carrier = Optional.ofNullable(ContainerUtil.getCarrier(this));
        if (this.lens != null) {
            for (Slot slot : new SlotCollectionIterator<IInventory>(this, this.fabric, this.lens, this.slots)) {
                this.adapters.put(((SlotAdapter)slot).slotNumber, (SlotAdapter)slot);
            }
        }
    }

    @Override
    public InventoryArchetype getArchetype() {
        this.init();
        return this.archetype;
    }

    @Overwrite
    public void func_75132_a(IContainerListener listener) {
        net.minecraft.inventory.Container container = (net.minecraft.inventory.Container)this;
        if (this.field_75149_d.contains(listener)) {
            listener.func_71110_a(container, this.func_75138_a());
            container.func_75142_b();
        } else {
            this.field_75149_d.add(listener);
            listener.func_71110_a(container, this.func_75138_a());
            container.func_75142_b();
        }
    }

    @Overwrite
    public void func_75142_b() {
        this.detectAndSendChanges(false);
    }

    @Override
    public void detectAndSendChanges(boolean captureOnly) {
        this.init();
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            net.minecraft.inventory.Slot slot = this.field_75151_b.get(i);
            net.minecraft.item.ItemStack itemstack = slot.func_75211_c();
            net.minecraft.item.ItemStack itemstack1 = (net.minecraft.item.ItemStack)this.field_75153_a.get(i);
            if (net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)itemstack1, (net.minecraft.item.ItemStack)itemstack)) continue;
            if (this.captureInventory) {
                ItemStackSnapshot originalItem = itemstack1.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack1).createSnapshot();
                ItemStackSnapshot newItem = itemstack.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack).createSnapshot();
                Slot adapter = null;
                try {
                    adapter = this.getContainerSlot(i);
                    if (this.shiftCraft) {
                        this.capturedCraftShiftTransactions.add(new SlotTransaction(adapter, originalItem, newItem));
                    } else {
                        this.capturedSlotTransactions.add(new SlotTransaction(adapter, originalItem, newItem));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    SpongeImpl.getLogger().error("SlotIndex out of LensBounds! Did the Container change after creation?", (Throwable)e);
                }
                if (captureOnly) continue;
            }
            itemstack1 = itemstack.func_77946_l();
            this.field_75153_a.set(i, (Object)itemstack1);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((net.minecraft.inventory.Container)this, i, itemstack1);
            }
        }
    }

    @Inject(method={"addSlotToContainer"}, at={@At(value="HEAD")})
    public void onAddSlotToContainer(net.minecraft.inventory.Slot slotIn, CallbackInfoReturnable<net.minecraft.inventory.Slot> cir) {
        this.dirty = true;
    }

    @Inject(method={"putStackInSlot"}, at={@At(value="HEAD")})
    public void onPutStackInSlot(int slotId, net.minecraft.item.ItemStack itemstack, CallbackInfo ci) {
        if (this.captureInventory) {
            this.init();
            net.minecraft.inventory.Slot slot = this.func_75139_a(slotId);
            if (slot != null) {
                ItemStackSnapshot originalItem = slot.func_75211_c().func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)slot.func_75211_c()).createSnapshot();
                ItemStackSnapshot newItem = itemstack.func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)itemstack).createSnapshot();
                Slot adapter = this.getContainerSlot(slotId);
                this.capturedSlotTransactions.add(new SlotTransaction(adapter, originalItem, newItem));
            }
        }
    }

    @Redirect(method={"slotChangedCraftingGrid"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/InventoryCraftResult;setInventorySlotContents(ILnet/minecraft/item/ItemStack;)V"))
    private void beforeSlotChangedCraftingGrid(InventoryCraftResult output, int index, net.minecraft.item.ItemStack itemstack) {
        if (!this.captureInventory) {
            return;
        }
        this.init();
        this.capturedCraftPreviewTransactions.clear();
        ItemStackSnapshot orig = ItemStackUtil.snapshotOf(output.func_70301_a(index));
        output.func_70299_a(index, itemstack);
        ItemStackSnapshot repl = ItemStackUtil.snapshotOf(output.func_70301_a(index));
        SlotAdapter slot = this.adapters.get(index);
        this.capturedCraftPreviewTransactions.add(new SlotTransaction(slot, orig, repl));
    }

    @Inject(method={"slotChangedCraftingGrid"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V")})
    private void afterSlotChangedCraftingGrid(World world, EntityPlayer player, InventoryCrafting craftingInventory, InventoryCraftResult output, CallbackInfo ci) {
        if (!this.capturedCraftPreviewTransactions.isEmpty()) {
            Object inv = this.query(QueryOperationTypes.INVENTORY_TYPE.of(CraftingInventory.class));
            if (!(inv instanceof CraftingInventory)) {
                SpongeImpl.getLogger().warn("Detected crafting but Sponge could not get a CraftingInventory for " + this.getClass().getName());
                return;
            }
            SlotTransaction previewTransaction = this.capturedCraftPreviewTransactions.get(this.capturedCraftPreviewTransactions.size() - 1);
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)craftingInventory, (World)world);
            SpongeCommonEventFactory.callCraftEventPre(player, (CraftingInventory)inv, previewTransaction, (CraftingRecipe)recipe, (net.minecraft.inventory.Container)this, this.capturedCraftPreviewTransactions);
            this.capturedCraftPreviewTransactions.clear();
        }
    }

    @Override
    public net.minecraft.item.ItemStack getPreviousCursor() {
        return this.previousCursor;
    }

    @Inject(method={"slotClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;grow(I)V", ordinal=1)})
    private void beforeOnTakeClickWithItem(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<Integer> cir) {
        this.previousCursor = player.field_71071_by.func_70445_o().func_77946_l();
    }

    @Inject(method={"slotClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/InventoryPlayer;setItemStack(Lnet/minecraft/item/ItemStack;)V", ordinal=3)})
    private void beforeOnTakeClick(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<Integer> cir) {
        this.previousCursor = player.field_71071_by.func_70445_o().func_77946_l();
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Slot;onTake(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", ordinal=5))
    private net.minecraft.item.ItemStack redirectOnTakeThrow(net.minecraft.inventory.Slot slot, EntityPlayer player, net.minecraft.item.ItemStack stackOnCursor) {
        this.lastCraft = null;
        net.minecraft.item.ItemStack result = slot.func_190901_a(player, stackOnCursor);
        if (this.lastCraft != null && slot instanceof SlotCrafting && this.lastCraft.isCancelled()) {
            stackOnCursor.func_190920_e(0);
        }
        return result;
    }

    @Inject(method={"slotClick"}, at={@At(value="RETURN")})
    private void onReturn(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<net.minecraft.item.ItemStack> cir) {
        this.lastCraft = null;
        this.previousCursor = null;
    }

    @Redirect(method={"slotClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/Container;transferStackInSlot(Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;"))
    private net.minecraft.item.ItemStack redirectTransferStackInSlot(net.minecraft.inventory.Container thisContainer, EntityPlayer player, int slotId) {
        net.minecraft.inventory.Slot slot = thisContainer.func_75139_a(slotId);
        if (!(slot instanceof SlotCrafting)) {
            return thisContainer.func_82846_b(player, slotId);
        }
        this.lastCraft = null;
        this.shiftCraft = true;
        net.minecraft.item.ItemStack result = thisContainer.func_82846_b(player, slotId);
        if (this.lastCraft != null && this.lastCraft.isCancelled()) {
            result = net.minecraft.item.ItemStack.field_190927_a;
        }
        this.shiftCraft = false;
        return result;
    }

    @Override
    public boolean capturingInventory() {
        return this.captureInventory;
    }

    @Override
    public void setCaptureInventory(boolean flag) {
        this.captureInventory = flag;
    }

    @Override
    public void setSpectatorChest(boolean spectatorChest) {
        this.spectatorChest = spectatorChest;
    }

    @Override
    public List<SlotTransaction> getCapturedTransactions() {
        return this.capturedSlotTransactions;
    }

    @Override
    public void setLastCraft(CraftItemEvent.Craft event) {
        this.lastCraft = event;
    }

    @Override
    public void setShiftCrafting(boolean flag) {
        this.shiftCraft = flag;
    }

    @Override
    public boolean isShiftCrafting() {
        return this.shiftCraft;
    }

    public SlotProvider<IInventory, net.minecraft.item.ItemStack> inventory$getSlotProvider() {
        this.init();
        return this.slots;
    }

    public Lens<IInventory, net.minecraft.item.ItemStack> inventory$getRootLens() {
        this.init();
        return this.lens;
    }

    public Fabric<IInventory> inventory$getFabric() {
        this.init();
        return this.fabric;
    }

    @Override
    public void setCanInteractWith(@Nullable Predicate<EntityPlayer> predicate) {
        this.canInteractWithPredicate = Optional.ofNullable(predicate);
    }

    @Override
    public Optional<Carrier> getCarrier() {
        return this.carrier;
    }

    @Override
    public Slot getContainerSlot(int slot) {
        Slot adapter = this.adapters.get(slot);
        if (adapter == null) {
            net.minecraft.inventory.Slot mcSlot = this.field_75151_b.get(slot);
            if (mcSlot == null) {
                SpongeImpl.getLogger().warn("Could not find slot #%s in Container %s", (Object)slot, (Object)this.getClass().getName());
                return null;
            }
            return (Slot)mcSlot;
        }
        return adapter;
    }

    @Override
    public void setPlugin(PluginContainer plugin) {
        this.plugin = plugin;
    }
}

