/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCombatEvent;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.border.IBorderListener;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.GameModeData;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.ChangeGameModeEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.PlayerChangeClientSettingsEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.chat.ChatVisibility;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeGameModeData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeJoinData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.effect.sound.SoundEffectHelper;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.living.human.EntityHuman;
import org.spongepowered.common.entity.player.PlayerKickHelper;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.interfaces.IMixinCommandSender;
import org.spongepowered.common.interfaces.IMixinCommandSource;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.IMixinPacketResourcePackSend;
import org.spongepowered.common.interfaces.IMixinServerScoreboard;
import org.spongepowered.common.interfaces.IMixinSubject;
import org.spongepowered.common.interfaces.IMixinTeam;
import org.spongepowered.common.interfaces.advancement.IMixinAdvancement;
import org.spongepowered.common.interfaces.advancement.IMixinPlayerAdvancements;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.network.IMixinNetHandlerPlayServer;
import org.spongepowered.common.interfaces.text.IMixinTitle;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.player.MixinEntityPlayer;
import org.spongepowered.common.service.user.SpongeUserStorageService;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.chat.ChatUtil;
import org.spongepowered.common.util.BookFaker;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.common.util.SkinUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.border.PlayerOwnBorderListener;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

@Mixin(value={EntityPlayerMP.class})
public abstract class MixinEntityPlayerMP
extends MixinEntityPlayer
implements Player,
IMixinSubject,
IMixinEntityPlayerMP,
IMixinCommandSender,
IMixinCommandSource {
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    @Final
    public PlayerInteractionManager field_71134_c;
    @Shadow
    @Final
    private PlayerAdvancements field_192042_bX;
    @Shadow
    private String field_71148_cg;
    @Shadow
    public NetHandlerPlayServer field_71135_a;
    @Shadow
    public int field_71144_ck;
    @Shadow
    private EntityPlayer.EnumChatVisibility field_71143_cn = EntityPlayer.EnumChatVisibility.FULL;
    @Shadow
    private boolean field_71140_co;
    @Shadow
    public boolean field_71136_j;
    @Shadow
    private float field_71149_ch;
    @Shadow
    private int field_71146_ci;
    @Shadow
    public boolean field_71137_h;
    @Shadow
    public int field_71139_cq;
    public int newExperience = 0;
    public int newLevel = 0;
    public int newTotalExperience = 0;
    public boolean keepsLevel = false;
    private boolean sleepingIgnored;
    private ItemStack packetItem;
    private final User user = this.getUserObject();
    private Set<SkinPart> skinParts = Sets.newHashSet();
    private int viewDistance;
    private TabList tabList = new SpongeTabList((EntityPlayerMP)this);
    private GameType pendingGameType;
    private Scoreboard spongeScoreboard = Sponge.getGame().getServer().getServerScoreboard().get();
    @Nullable
    private Vector3d velocityOverride = null;
    private boolean healthScaling = false;
    private double healthScale = 20.0;
    @Nullable
    private WorldBorder worldBorder;
    private final PlayerOwnBorderListener borderListener = new PlayerOwnBorderListener((EntityPlayerMP)this);
    private boolean keepInventory = false;
    float cachedHealth = -1.0f;
    float cachedScaledHealth = -1.0f;

    @Shadow
    public abstract net.minecraft.entity.Entity func_175398_C();

    @Shadow
    public abstract void func_175399_e(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_71016_p();

    @Override
    @Shadow
    public abstract void func_175145_a(StatBase var1);

    @Shadow
    public abstract StatisticsManagerServer func_147099_x();

    @Shadow
    public abstract void func_71007_a(IInventory var1);

    @Shadow
    public abstract void func_180468_a(IInteractionObject var1);

    @Shadow
    public abstract void func_184826_a(AbstractHorse var1, IInventory var2);

    @Shadow
    public abstract void func_71053_j();

    @Shadow
    private void func_71117_bO() {
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        if (this.healthScaling) {
            compound.func_74780_a("HealthScale", this.healthScale);
        }
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        if (compound.func_150297_b("HealthScale", 6)) {
            this.healthScaling = true;
            this.healthScale = compound.func_74769_h("HealthScale");
        }
    }

    @Inject(method={"removeEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V")})
    private void onRemoveEntity(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        if (entityIn instanceof EntityHuman) {
            ((EntityHuman)entityIn).onRemovedFrom((EntityPlayerMP)this);
        }
    }

    @Override
    public boolean keepInventory() {
        return this.keepInventory;
    }

    @Override
    @Overwrite
    public void func_70645_a(DamageSource cause) {
        boolean tracksEntityDeaths;
        PhaseTracker phaseTracker;
        DestructEntityEvent.Death event = SpongeCommonEventFactory.callDestructEntityEventDeath((EntityLivingBase)((EntityPlayerMP)this), cause);
        if (!this.field_70170_p.field_72995_K) {
            phaseTracker = PhaseTracker.getInstance();
            PhaseData peek = phaseTracker.getCurrentPhaseData();
            IPhaseState<?> state = peek.state;
            tracksEntityDeaths = state.tracksEntityDeaths();
        } else {
            phaseTracker = null;
            tracksEntityDeaths = false;
        }
        try (PhaseContext context = !tracksEntityDeaths ? (PhaseContext)((BasicEntityContext)EntityPhase.State.DEATH.createPhaseContext().source(this)).setDamageSource((org.spongepowered.api.event.cause.entity.damage.source.DamageSource)cause).buildAndSwitch() : null;){
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages");
            this.field_71135_a.func_147359_a((Packet)new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED, flag));
            if (flag) {
                Team team = this.func_96124_cp();
                if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
                    if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                        this.field_71133_b.func_184103_al().func_177453_a((EntityPlayer)((EntityPlayerMP)this), this.func_110142_aN().func_151521_b());
                    } else if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                        this.field_71133_b.func_184103_al().func_177452_b((EntityPlayer)((EntityPlayerMP)this), this.func_110142_aN().func_151521_b());
                    }
                } else {
                    this.field_71133_b.func_184103_al().func_148539_a(this.func_110142_aN().func_151521_b());
                }
            }
            this.func_192030_dh();
            if (!event.getKeepInventory() && !this.func_175149_v()) {
                this.func_190776_cN();
                this.field_71071_by.func_70436_m();
            }
            for (ScoreObjective scoreobjective : this.func_96123_co().func_96520_a(IScoreCriteria.field_96642_c)) {
                Score score = this.func_96123_co().func_96529_a(this.func_70005_c_(), scoreobjective);
                score.func_96648_a();
            }
            EntityLivingBase entitylivingbase = this.func_94060_bK();
            if (entitylivingbase != null) {
                EntityList.EntityEggInfo entitylist$entityegginfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(EntityList.func_191301_a((net.minecraft.entity.Entity)entitylivingbase));
                if (entitylist$entityegginfo != null) {
                    this.func_71029_a(entitylist$entityegginfo.field_151513_e);
                }
                entitylivingbase.func_191956_a((net.minecraft.entity.Entity)((EntityPlayerMP)this), this.field_70744_aE, cause);
            }
            this.func_71029_a(StatList.field_188069_A);
            this.func_175145_a(StatList.field_188098_h);
            this.func_70066_B();
            this.func_70052_a(0, false);
            this.func_110142_aN().func_94549_h();
            this.keepInventory = event.getKeepInventory();
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="HEAD")})
    public void onClonePlayer(EntityPlayerMP oldPlayer, boolean respawnFromEnd, CallbackInfo ci) {
        IMixinEntity oldEntity = (IMixinEntity)oldPlayer;
        NBTTagCompound old = oldEntity.getEntityData();
        if (old.func_74764_b("SpongeData")) {
            this.getEntityData().func_74782_a("SpongeData", (NBTBase)old.func_74775_l("SpongeData"));
            this.readFromNbt(this.getSpongeData());
        }
    }

    @Redirect(method={"copyFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z"))
    private boolean keepInventory(GameRules gameRules, String key, EntityPlayerMP corpse, boolean keepEverything) {
        boolean keep = ((IMixinEntityPlayer)corpse).keepInventory();
        if (!keep) {
            this.field_71071_by.func_70455_b(corpse.field_71071_by);
            corpse.field_71071_by.func_174888_l();
        }
        return keep;
    }

    @Override
    public IMixinWorldServer getMixinWorld() {
        return (IMixinWorldServer)this.field_70170_p;
    }

    @Override
    @Nullable
    @Overwrite
    public net.minecraft.entity.Entity func_184204_a(int dimensionId) {
        return EntityUtil.teleportPlayerToDimension((EntityPlayerMP)this, dimensionId);
    }

    @Override
    public GameProfile getProfile() {
        return this.user.getProfile();
    }

    @Override
    public boolean isOnline() {
        return this.user.isOnline();
    }

    @Override
    public Optional<Player> getPlayer() {
        return Optional.of(this);
    }

    @Override
    public User getUserObject() {
        UserStorageService service = SpongeImpl.getGame().getServiceManager().provideUnchecked(UserStorageService.class);
        if (this.isFake) {
            return service.getOrCreate(SpongeUserStorageService.FAKEPLAYER_PROFILE);
        }
        return service.getOrCreate((GameProfile)this.func_146103_bH());
    }

    @Inject(method={"handleClientSettings"}, at={@At(value="HEAD")})
    public void postClientSettingsEvent(CPacketClientSettings packet, CallbackInfo ci) {
        Sponge.getCauseStackManager().pushCause(this);
        PlayerChangeClientSettingsEvent event = SpongeEventFactory.createPlayerChangeClientSettingsEvent(Sponge.getCauseStackManager().getCurrentCause(), (ChatVisibility)packet.func_149523_e(), SkinUtil.fromFlags(packet.func_149521_d()), LocaleCache.getLocale(packet.func_149524_c()), this, packet.func_149520_f(), packet.field_149528_b);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
    }

    @Inject(method={"handleClientSettings"}, at={@At(value="RETURN")})
    public void captureClientSettings(CPacketClientSettings packet, CallbackInfo ci) {
        this.skinParts = SkinUtil.fromFlags(packet.func_149521_d());
        this.viewDistance = packet.field_149528_b;
    }

    @Override
    public Locale getLocale() {
        return LocaleCache.getLocale(this.field_71148_cg);
    }

    @Override
    public int getViewDistance() {
        return this.viewDistance;
    }

    @Override
    public ChatVisibility getChatVisibility() {
        return (ChatVisibility)this.field_71143_cn;
    }

    @Override
    public boolean isChatColorsEnabled() {
        return this.field_71140_co;
    }

    @Override
    public Set<SkinPart> getDisplayedSkinParts() {
        return this.skinParts;
    }

    @Override
    public void sendMessage(org.spongepowered.api.text.chat.ChatType type, Text message) {
        if (this.isFake) {
            return;
        }
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)message, (Object)"message");
        ITextComponent component = SpongeTexts.toComponent(message);
        if (type == ChatTypes.ACTION_BAR) {
            component = SpongeTexts.fixActionBarFormatting(component);
        }
        this.field_71135_a.func_147359_a((Packet)new SPacketChat(component, (ChatType)type));
    }

    @Overwrite
    public void func_145747_a(ITextComponent component) {
        if (this.isFake) {
            return;
        }
        ChatUtil.sendMessage(component, MessageChannel.fixed(this), (CommandSource)this.field_71133_b, false);
    }

    @Override
    public void sendBookView(BookView bookView) {
        if (this.isFake) {
            return;
        }
        BookFaker.fakeBookView(bookView, this);
    }

    @Override
    public void sendTitle(Title title) {
        if (this.isFake) {
            return;
        }
        ((IMixinTitle)((Object)title)).send((EntityPlayerMP)this);
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position) {
        if (this.isFake) {
            return;
        }
        this.spawnParticles(particleEffect, position, Integer.MAX_VALUE);
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, Vector3d position, int radius) {
        if (this.isFake) {
            return;
        }
        Preconditions.checkNotNull((Object)particleEffect, (Object)"The particle effect cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null");
        Preconditions.checkArgument((radius > 0 ? 1 : 0) != 0, (Object)"The radius has to be greater then zero!");
        List<Packet<?>> packets = SpongeParticleHelper.toPackets((SpongeParticleEffect)particleEffect, position);
        if (!packets.isEmpty() && position.sub(this.field_70165_t, this.field_70163_u, this.field_70161_v).lengthSquared() < (double)((long)radius * (long)radius)) {
            for (Packet<?> packet : packets) {
                this.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @Override
    public PlayerConnection getConnection() {
        return (PlayerConnection)this.field_71135_a;
    }

    @Overwrite
    public String func_71114_r() {
        return NetworkUtil.getHostString(this.field_71135_a.field_147371_a.func_74430_c());
    }

    @Override
    public void setLevel(int level) {
        this.field_71068_ca = level;
        this.field_71144_ck = -1;
    }

    @Override
    public String getSubjectCollectionIdentifier() {
        return ((IMixinSubject)((Object)this.user)).getSubjectCollectionIdentifier();
    }

    @Override
    public String getIdentifier() {
        return this.user.getIdentifier();
    }

    @Override
    public Tristate permDefault(String permission) {
        return ((IMixinSubject)((Object)this.user)).permDefault(permission);
    }

    @Override
    public void refreshXpHealthAndFood() {
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        this.refreshScaledHealth();
    }

    @Override
    public void setPacketItem(ItemStack itemstack) {
        this.packetItem = itemstack;
    }

    @Override
    public void refreshExp() {
        this.field_71144_ck = -1;
    }

    @Override
    public void restorePacketItem(EnumHand hand) {
        if (this.packetItem.func_190926_b()) {
            return;
        }
        this.field_71137_h = true;
        this.func_184611_a(hand, this.packetItem);
        Slot slot = this.field_71070_bA.func_75147_a((IInventory)this.field_71071_by, this.field_71071_by.field_70461_c);
        this.field_71070_bA.func_75142_b();
        this.field_71137_h = false;
        this.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_71070_bA.field_75152_c, slot.field_75222_d, this.packetItem));
    }

    @Override
    public Optional<Container> getOpenInventory() {
        return Optional.ofNullable((Container)this.field_71070_bA);
    }

    @Override
    public Optional<Container> openInventory(Inventory inventory) throws IllegalArgumentException {
        return Optional.ofNullable((Container)SpongeCommonEventFactory.displayContainer((EntityPlayerMP)this, inventory));
    }

    @Override
    public boolean closeInventory() throws IllegalArgumentException {
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(this.field_71071_by.func_70445_o());
        return !SpongeCommonEventFactory.callInteractInventoryCloseEvent(this.field_71070_bA, (EntityPlayerMP)this, cursor, cursor, false).isCancelled();
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        if (scoreboard == null) {
            scoreboard = Sponge.getGame().getServer().getServerScoreboard().get();
        }
        ((IMixinServerScoreboard)((Object)this.spongeScoreboard)).removePlayer((EntityPlayerMP)this, true);
        this.spongeScoreboard = scoreboard;
        ((IMixinServerScoreboard)((Object)this.spongeScoreboard)).addPlayer((EntityPlayerMP)this);
    }

    @Override
    public void initScoreboard() {
        ((IMixinServerScoreboard)((Object)this.spongeScoreboard)).addPlayer((EntityPlayerMP)this);
    }

    @Override
    public Text getTeamRepresentation() {
        return Text.of(this.func_70005_c_());
    }

    @Override
    public MessageChannel getDeathMessageChannel() {
        EntityPlayerMP player = (EntityPlayerMP)this;
        if (player.field_70170_p.func_82736_K().func_82766_b("showDeathMessages")) {
            Team team = player.func_96124_cp();
            if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
                if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                    return ((IMixinTeam)team).getTeamChannel(player);
                }
                if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                    return ((IMixinTeam)team).getNonTeamChannel();
                }
            } else {
                return this.getMessageChannel();
            }
        }
        return MessageChannel.TO_NONE;
    }

    @Override
    public net.minecraft.scoreboard.Scoreboard func_96123_co() {
        return (net.minecraft.scoreboard.Scoreboard)this.spongeScoreboard;
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.spongeScoreboard;
    }

    @Override
    public void kick() {
        this.kick(Text.of(SpongeImpl.getGame().getRegistry().getTranslationById("disconnect.disconnected").get(), new Object[0]));
    }

    @Override
    public void kick(Text message) {
        ITextComponent component = SpongeTexts.toComponent(message);
        PlayerKickHelper.kickPlayer((EntityPlayerMP)this, component);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume) {
        this.playSound(sound, category, position, volume, 1.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch) {
        this.playSound(sound, category, position, volume, pitch, 0.0);
    }

    @Override
    public void playSound(SoundType sound, SoundCategory category, Vector3d position, double volume, double pitch, double minVolume) {
        SoundEvent event;
        try {
            event = SoundEvents.func_187510_a((String)sound.getId());
        }
        catch (IllegalStateException e) {
            this.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(sound.getId(), (net.minecraft.util.SoundCategory)category, position.getX(), position.getY(), position.getZ(), (float)Math.max(minVolume, volume), (float)pitch));
            return;
        }
        this.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(event, (net.minecraft.util.SoundCategory)category, position.getX(), position.getY(), position.getZ(), (float)Math.max(minVolume, volume), (float)pitch));
    }

    @Override
    public void stopSounds() {
        this.stopSounds0(null, null);
    }

    @Override
    public void stopSounds(SoundType sound) {
        this.stopSounds0((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), null);
    }

    @Override
    public void stopSounds(SoundCategory category) {
        this.stopSounds0(null, (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    @Override
    public void stopSounds(SoundType sound, SoundCategory category) {
        this.stopSounds0((SoundType)Preconditions.checkNotNull((Object)sound, (Object)"sound"), (SoundCategory)Preconditions.checkNotNull((Object)category, (Object)"category"));
    }

    private void stopSounds0(@Nullable SoundType sound, @Nullable SoundCategory category) {
        this.field_71135_a.func_147359_a((Packet)SoundEffectHelper.createStopSoundPacket(sound, category));
    }

    @Override
    public void playRecord(Vector3i position, RecordType recordType) {
        this.playRecord0(position, (RecordType)Preconditions.checkNotNull((Object)recordType, (Object)"recordType"));
    }

    @Override
    public void stopRecord(Vector3i position) {
        this.playRecord0(position, null);
    }

    private void playRecord0(Vector3i position, @Nullable RecordType recordType) {
        this.field_71135_a.func_147359_a((Packet)SpongeRecordType.createPacket(position, recordType));
    }

    @Override
    public void sendResourcePack(ResourcePack pack) {
        SPacketResourcePackSend packet = new SPacketResourcePackSend();
        ((IMixinPacketResourcePackSend)packet).setResourcePack(pack);
        this.field_71135_a.func_147359_a((Packet)packet);
    }

    @Inject(method={"markPlayerActive()V"}, at={@At(value="HEAD")})
    private void onPlayerActive(CallbackInfo ci) {
        ((IMixinNetHandlerPlayServer)this.field_71135_a).resendLatestResourcePackRequest();
    }

    @Override
    public CommandSource asCommandSource() {
        return this;
    }

    @Override
    public ICommandSender asICommandSender() {
        return (ICommandSender)this;
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.sleepingIgnored;
    }

    @Override
    public void setSleepingIgnored(boolean sleepingIgnored) {
        this.sleepingIgnored = sleepingIgnored;
    }

    @Override
    public Vector3d getVelocity() {
        if (this.velocityOverride != null) {
            return this.velocityOverride;
        }
        return super.getVelocity();
    }

    @Override
    public void setImplVelocity(Vector3d velocity) {
        super.setImplVelocity(velocity);
        this.velocityOverride = null;
    }

    @Override
    public void setVelocityOverride(@Nullable Vector3d velocity) {
        this.velocityOverride = velocity;
    }

    @Override
    public CarriedInventory<? extends Carrier> getInventory() {
        return (CarriedInventory)this.field_71071_by;
    }

    @Inject(method={"setGameType(Lnet/minecraft/world/GameType;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetGameType(GameType gameType, CallbackInfo ci) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(this);
            ChangeGameModeEvent.TargetPlayer event = SpongeEventFactory.createChangeGameModeEventTargetPlayer(Sponge.getCauseStackManager().getCurrentCause(), (GameMode)this.field_71134_c.func_73081_b(), (GameMode)gameType, this);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
            this.pendingGameType = (GameType)event.getGameMode();
        }
    }

    @ModifyVariable(method={"Lnet/minecraft/entity/player/EntityPlayerMP;setGameType(Lnet/minecraft/world/GameType;)V"}, at=@At(value="HEAD", remap=false), argsOnly=true)
    private GameType assignPendingGameType(GameType gameType) {
        return this.pendingGameType;
    }

    @Redirect(method={"onDeath"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z", ordinal=0))
    public boolean onGetGameRules(GameRules gameRules, String gameRule) {
        return false;
    }

    @Override
    public TabList getTabList() {
        return this.tabList;
    }

    @Override
    public void setTargetedLocation(@Nullable Vector3d vec) {
        super.setTargetedLocation(vec);
        this.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(VecHelper.toBlockPos(this.getTargetedLocation())));
    }

    @Override
    public JoinData getJoinData() {
        return new SpongeJoinData(SpongePlayerDataHandler.getFirstJoined(this.func_110124_au()).get(), Instant.now());
    }

    @Override
    public Value<Instant> firstPlayed() {
        return new SpongeValue<Instant>(Keys.FIRST_DATE_PLAYED, Instant.EPOCH, SpongePlayerDataHandler.getFirstJoined(this.func_110124_au()).get());
    }

    @Override
    public Value<Instant> lastPlayed() {
        return new SpongeValue<Instant>(Keys.LAST_DATE_PLAYED, Instant.EPOCH, Instant.now());
    }

    @Override
    public GameModeData getGameModeData() {
        return new SpongeGameModeData((GameMode)this.field_71134_c.func_73081_b());
    }

    @Override
    public Value<GameMode> gameMode() {
        return new SpongeValue<GameMode>(Keys.GAME_MODE, DataConstants.Catalog.DEFAULT_GAMEMODE, (GameMode)this.field_71134_c.func_73081_b());
    }

    @Override
    @Nullable
    public Text getDisplayNameText() {
        return Text.of(this.func_70005_c_());
    }

    @Override
    public void setDisplayName(@Nullable Text displayName) {
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getJoinData());
        manipulators.add(this.getGameModeData());
    }

    @Override
    public void sendBlockChange(BlockPos pos, IBlockState state) {
        SPacketBlockChange packet = new SPacketBlockChange();
        packet.field_179828_a = pos;
        packet.field_148883_d = state;
        this.field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.sendBlockChange(new BlockPos(x, y, z), (IBlockState)state);
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SPacketBlockChange packet = new SPacketBlockChange(this.field_70170_p, new BlockPos(x, y, z));
        this.field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    @Nullable
    public EntityItem func_71040_bB(boolean dropAll) {
        ItemStack currentItem = this.field_71071_by.func_70448_g();
        if (currentItem.func_190926_b()) {
            return null;
        }
        org.spongepowered.api.item.inventory.Slot slot = (org.spongepowered.api.item.inventory.Slot)((Inventory)this.field_71069_bz).query(QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class)).query(QueryOperationTypes.INVENTORY_PROPERTY.of(SlotIndex.of(this.field_71071_by.field_70461_c)));
        ItemStackSnapshot originalItem = ItemStackUtil.snapshotOf(currentItem);
        ItemStack itemToDrop = this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, dropAll && !currentItem.func_190926_b() ? currentItem.func_190916_E() : 1);
        ((IMixinContainer)this.field_71069_bz).getCapturedTransactions().add(new SlotTransaction(slot, originalItem, ItemStackUtil.snapshotOf(this.field_71071_by.func_70448_g())));
        return this.func_146097_a(itemToDrop, false, true);
    }

    @Override
    public void func_184597_cx() {
        if (this.field_184627_bm.func_190926_b()) {
            ((EntityPlayerMP)this).func_71120_a(((EntityPlayerMP)this).field_71069_bz);
        }
        super.func_184597_cx();
    }

    @Override
    public Inventory getEnderChestInventory() {
        return (Inventory)this.field_71078_a;
    }

    @Override
    public boolean respawnPlayer() {
        if (this.func_110143_aJ() > 0.0f) {
            return false;
        }
        this.field_71135_a.field_147369_b = this.field_71133_b.func_184103_al().func_72368_a((EntityPlayerMP)this, this.field_71093_bK, false);
        return true;
    }

    @Inject(method={"closeContainer"}, at={@At(value="RETURN")})
    public void onCloseContainer(CallbackInfo ci) {
        IMixinContainer mixinContainer = (IMixinContainer)this.field_71070_bA;
        if (mixinContainer.capturingInventory()) {
            mixinContainer.setCaptureInventory(false);
            mixinContainer.getCapturedTransactions().clear();
        }
    }

    @Inject(method={"displayGUIChest"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/EntityPlayerMP;openContainer:Lnet/minecraft/inventory/Container;", opcode=181, ordinal=1, shift=At.Shift.AFTER)})
    public void onSetContainer(IInventory chestInventory, CallbackInfo ci) {
        if (!(chestInventory instanceof IInteractionObject) && this.field_71070_bA instanceof ContainerChest && this.func_175149_v()) {
            SpongeImpl.getLogger().warn("Opening fallback ContainerChest for inventory '{}'. Most API inventory methods will not be supported", (Object)chestInventory);
            ((IMixinContainer)this.field_71070_bA).setSpectatorChest(true);
        }
    }

    @Override
    public Optional<Entity> getSpectatorTarget() {
        net.minecraft.entity.Entity entity = this.func_175398_C();
        return entity == this ? Optional.empty() : Optional.of((Entity)entity);
    }

    @Override
    public void setSpectatorTarget(@Nullable Entity entity) {
        this.func_175399_e((net.minecraft.entity.Entity)entity);
    }

    @Override
    public MessageChannelEvent.Chat simulateChat(Text message, Cause cause) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        TextComponentTranslation component = new TextComponentTranslation("chat.type.text", new Object[]{SpongeTexts.toComponent(this.getDisplayNameText()), SpongeTexts.toComponent(message)});
        Text[] messages = SpongeTexts.splitChatMessage(component);
        MessageChannel originalChannel = this.getMessageChannel();
        MessageChannelEvent.Chat event = SpongeEventFactory.createMessageChannelEventChat(cause, originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(messages[0], messages[1]), message, false);
        if (!SpongeImpl.postEvent(event) && !event.isMessageCancelled()) {
            event.getChannel().ifPresent(channel -> channel.send(this, event.getMessage(), ChatTypes.CHAT));
        }
        return event;
    }

    @Override
    public Optional<WorldBorder> getWorldBorder() {
        return Optional.ofNullable(this.worldBorder);
    }

    @Override
    public void setWorldBorder(@Nullable WorldBorder border, Cause cause) {
        if (this.worldBorder == border) {
            return;
        }
        if (!SpongeImpl.postEvent(SpongeEventFactory.createChangeWorldBorderEventTargetPlayer(cause, Optional.ofNullable(this.worldBorder), Optional.ofNullable(border), this))) {
            if (this.worldBorder != null) {
                ((net.minecraft.world.border.WorldBorder)this.worldBorder).field_177758_a.remove(this.borderListener);
            }
            this.worldBorder = border;
            if (this.worldBorder != null) {
                ((net.minecraft.world.border.WorldBorder)this.worldBorder).func_177737_a((IBorderListener)this.borderListener);
                this.field_71135_a.func_147359_a((Packet)new SPacketWorldBorder((net.minecraft.world.border.WorldBorder)this.worldBorder, SPacketWorldBorder.Action.INITIALIZE));
            } else {
                this.field_71135_a.func_147359_a((Packet)new SPacketWorldBorder(this.field_70170_p.func_175723_af(), SPacketWorldBorder.Action.INITIALIZE));
            }
        }
    }

    @Override
    public PlayerOwnBorderListener getWorldBorderListener() {
        return this.borderListener;
    }

    @Inject(method={"sendSlotContents"}, at={@At(value="HEAD")})
    private void sendSlotContents(net.minecraft.inventory.Container containerToSend, int slotInd, ItemStack stack, CallbackInfo ci) {
        if (containerToSend.func_75139_a(slotInd) instanceof SlotCrafting) {
            this.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(containerToSend.field_75152_c, slotInd, stack));
        }
    }

    @Redirect(method={"onUpdateEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;getHealth()F"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/player/EntityPlayerMP;lastHealth:F"), to=@At(value="INVOKE", target="Lnet/minecraft/network/play/server/SPacketUpdateHealth;<init>(FIF)V")))
    private float spongeGetScaledHealthForPacket(EntityPlayerMP entityPlayerMP) {
        return this.getInternalScaledHealth();
    }

    @Inject(method={"onUpdateEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;getTotalArmorValue()I", ordinal=0)})
    private void updateHealthPriorToArmor(CallbackInfo ci) {
        this.refreshScaledHealth();
    }

    @Override
    public void setHealthScale(double scale) {
        Preconditions.checkArgument((scale > 0.0 ? 1 : 0) != 0, (Object)"Health scale must be greater than 0!");
        Preconditions.checkArgument((scale < 3.4028234663852886E38 ? 1 : 0) != 0, (Object)"Health scale cannot exceed Float.MAX_VALUE!");
        this.healthScale = scale;
        this.healthScaling = true;
        this.refreshScaledHealth();
    }

    @Override
    public void refreshScaledHealth() {
        Set dirtyInstances = ((AttributeMap)this.func_110140_aT()).func_111161_b();
        this.injectScaledHealth(dirtyInstances, true);
        this.sendHealthUpdate();
        this.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(this.func_145782_y(), (Collection)dirtyInstances));
        dirtyInstances.clear();
    }

    public void sendHealthUpdate() {
        this.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(this.getInternalScaledHealth(), this.func_71024_bL().func_75116_a(), this.func_71024_bL().func_75115_e()));
    }

    @Override
    public void injectScaledHealth(Collection<IAttributeInstance> set, boolean force) {
        if (!this.healthScaling && !force) {
            return;
        }
        Iterator<IAttributeInstance> iter = set.iterator();
        while (iter.hasNext()) {
            IAttributeInstance dirtyInstance = iter.next();
            if (!dirtyInstance.func_111123_a().func_111108_a().equals("generic.maxHealth")) continue;
            iter.remove();
            break;
        }
        RangedAttribute maxHealth = new RangedAttribute(null, "generic.maxHealth", this.healthScaling ? this.healthScale : (double)this.func_110138_aP(), 0.0, 3.4028234663852886E38);
        maxHealth.func_111117_a("Max Health");
        maxHealth.func_111112_a(true);
        set.add((IAttributeInstance)new ModifiableAttributeInstance(this.func_110140_aT(), (IAttribute)maxHealth));
    }

    @Override
    public double getHealthScale() {
        return this.healthScale;
    }

    @Override
    public float getInternalScaledHealth() {
        if (this.healthScaling) {
            if (this.cachedHealth != -1.0f && this.func_110143_aJ() == this.cachedHealth && this.cachedScaledHealth != -1.0f) {
                return this.cachedScaledHealth;
            }
            this.cachedHealth = this.func_110143_aJ();
            this.cachedScaledHealth = (float)((double)(this.cachedHealth / this.func_110138_aP()) * this.healthScale);
            return this.cachedScaledHealth;
        }
        return this.func_110143_aJ();
    }

    @Override
    public boolean isHealthScaled() {
        return this.healthScaling;
    }

    @Override
    public void setHealthScaled(boolean scaled) {
        this.healthScaling = scaled;
    }

    @Override
    public void updateDataManagerForScaledHealth() {
        this.field_70180_af.func_187227_b(EntityLivingBase.field_184632_c, (Object)Float.valueOf(this.getInternalScaledHealth()));
    }

    @Override
    public CooldownTracker getCooldownTracker() {
        return (CooldownTracker)this.shadow$func_184811_cZ();
    }

    @Redirect(method={"readEntityFromNBT"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getForceGamemode()Z"))
    private boolean onCheckForcedGameMode(MinecraftServer minecraftServer) {
        return minecraftServer.func_104056_am() && !this.hasForcedGamemodeOverridePermission();
    }

    @Override
    public boolean hasForcedGamemodeOverridePermission() {
        return this.hasPermission(this.getActiveContexts(), "minecraft.force-gamemode.override");
    }

    @Override
    public AdvancementProgress getProgress(org.spongepowered.api.advancement.Advancement advancement) {
        Preconditions.checkNotNull((Object)advancement, (Object)"advancement");
        Preconditions.checkState((boolean)((IMixinAdvancement)((Object)advancement)).isRegistered(), (Object)"The advancement must be registered");
        return (AdvancementProgress)this.field_192042_bX.func_192747_a((Advancement)advancement);
    }

    @Override
    public Collection<AdvancementTree> getUnlockedAdvancementTrees() {
        return ((IMixinPlayerAdvancements)this.field_192042_bX).getAdvancementTrees();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This is an internal method not intended for use with Players as it causes the player to be placed into an undefined state. Consider putting them through the normal death process instead.");
    }
}

