/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smelting;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.api.item.recipe.smelting.SmeltingResult;

public class SpongeSmeltingRecipe
implements SmeltingRecipe {
    private final ItemStackSnapshot exemplaryResult;
    private final ItemStackSnapshot exemplaryIngredient;
    private final Predicate<ItemStackSnapshot> ingredientPredicate;
    private final double experience;

    public SpongeSmeltingRecipe(ItemStackSnapshot exemplaryResult, ItemStackSnapshot exemplaryIngredient, Predicate<ItemStackSnapshot> ingredientPredicate, double experience) {
        Preconditions.checkNotNull((Object)exemplaryResult, (Object)"exemplaryResult");
        Preconditions.checkArgument((exemplaryResult != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The result must not be ItemStackSnapshot.NONE.");
        Preconditions.checkNotNull((Object)exemplaryIngredient, (Object)"exemplaryIngredient");
        Preconditions.checkArgument((exemplaryIngredient != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The ingredient must not be ItemStackSnapshot.NONE.");
        Preconditions.checkNotNull(ingredientPredicate, (Object)"ingredientPredicate");
        Preconditions.checkArgument((boolean)ingredientPredicate.test(exemplaryIngredient), (Object)"The ingredient predicate does not allow the specified exemplary ingredient.");
        Preconditions.checkArgument((experience >= 0.0 ? 1 : 0) != 0, (Object)"The experience must be non-negative.");
        this.exemplaryResult = exemplaryResult;
        this.exemplaryIngredient = exemplaryIngredient;
        this.ingredientPredicate = ingredientPredicate;
        this.experience = experience;
    }

    @Override
    @Nonnull
    public ItemStackSnapshot getExemplaryResult() {
        return this.exemplaryResult;
    }

    @Override
    @Nonnull
    public ItemStackSnapshot getExemplaryIngredient() {
        return this.exemplaryIngredient;
    }

    @Override
    public boolean isValid(@Nonnull ItemStackSnapshot ingredient) {
        return this.ingredientPredicate.test(ingredient);
    }

    @Override
    @Nonnull
    public Optional<SmeltingResult> getResult(@Nonnull ItemStackSnapshot ingredient) {
        if (this.isValid(ingredient)) {
            return Optional.of(new SmeltingResult(this.exemplaryResult, this.experience));
        }
        return Optional.empty();
    }
}

