/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.util;

import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.common.item.inventory.adapter.impl.comp.CraftingGridInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingGridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.fabric.IInventoryFabric;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static CraftingGridInventory toSpongeInventory(InventoryCrafting inv) {
        IInventoryFabric fabric = new IInventoryFabric((IInventory)inv);
        CraftingGridInventoryLensImpl lens = new CraftingGridInventoryLensImpl(0, inv.func_174922_i(), inv.func_174923_h(), inv.func_174922_i(), SlotLensImpl::new);
        return new CraftingGridInventoryAdapter((Fabric<IInventory>)fabric, lens);
    }

    public static InventoryCrafting toNativeInventory(CraftingGridInventory inv) {
        Fabric fabric = ((CraftingGridInventoryAdapter)inv).getFabric();
        for (IInventory inventory : fabric.allInventories()) {
            if (!(inventory instanceof InventoryCrafting)) continue;
            return (InventoryCrafting)inventory;
        }
        throw new IllegalStateException("Invalid CraftingGridInventory. Could not find InventoryCrafting.");
    }

    public static Optional<Inventory> getDoubleChestInventory(TileEntityChest chest) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = chest.func_174877_v().func_177972_a(enumfacing);
            TileEntity tileentity1 = chest.func_145831_w().func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityChest) || tileentity1.func_145838_q() != chest.func_145838_q()) continue;
            InventoryLargeChest inventory = enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH ? new InventoryLargeChest("container.chestDouble", (ILockableContainer)chest, (ILockableContainer)((TileEntityChest)tileentity1)) : new InventoryLargeChest("container.chestDouble", (ILockableContainer)((TileEntityChest)tileentity1), (ILockableContainer)chest);
            return Optional.of((Inventory)inventory);
        }
        return Optional.empty();
    }
}

