/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.minecraft.container;

import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.RealLens;

public class ContainerLens
extends RealLens {
    protected List<Lens<IInventory, ItemStack>> viewedInventories;
    private List<Lens<IInventory, ItemStack>> additonal = Collections.emptyList();

    public ContainerLens(InventoryAdapter<IInventory, ItemStack> adapter, SlotProvider<IInventory, ItemStack> slots, List<Lens<IInventory, ItemStack>> lenses) {
        this(adapter, slots, lenses, Collections.emptyList());
    }

    public ContainerLens(InventoryAdapter<IInventory, ItemStack> adapter, SlotProvider<IInventory, ItemStack> slots, List<Lens<IInventory, ItemStack>> lenses, List<Lens<IInventory, ItemStack>> additonal) {
        this(adapter, slots);
        this.viewedInventories = lenses;
        this.additonal = additonal;
        this.init(slots);
    }

    public ContainerLens(InventoryAdapter<IInventory, ItemStack> adapter, SlotProvider<IInventory, ItemStack> slots) {
        super(0, adapter.getFabric().getSize(), adapter, slots);
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            ++slot;
        }
        for (Lens<IInventory, ItemStack> lens : this.viewedInventories) {
            this.addSpanningChild(lens, new InventoryProperty[0]);
        }
        for (Lens<IInventory, ItemStack> lens : this.additonal) {
            this.addChild(lens, new InventoryProperty[0]);
        }
    }
}

