/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.MainPlayerInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.HotbarLens;
import org.spongepowered.common.item.inventory.lens.comp.MainPlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.HotbarLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class MainPlayerInventoryLensImpl
extends GridInventoryLensImpl
implements MainPlayerInventoryLens<IInventory, ItemStack> {
    private static final int MAIN_INVENTORY_HEIGHT = 3;
    private static final int INVENTORY_WIDTH = 9;
    private HotbarLensImpl hotbar;
    private GridInventoryLensImpl grid;
    private boolean isContainer;

    public MainPlayerInventoryLensImpl(int base, SlotProvider<IInventory, ItemStack> slots, boolean isContainer) {
        this(base, MainPlayerInventoryAdapter.class, slots, isContainer);
    }

    public MainPlayerInventoryLensImpl(int base, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots, boolean isContainer) {
        super(base, 9, 4, adapterType, slots);
        this.isContainer = isContainer;
        this.lateInit(slots);
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
    }

    private void lateInit(SlotProvider<IInventory, ItemStack> slots) {
        int base = this.base;
        if (this.isContainer) {
            this.grid = new GridInventoryLensImpl(base, 9, 3, 9, slots);
            this.hotbar = new HotbarLensImpl(base += 27, 9, slots);
            this.addSpanningChild(this.grid, new InventoryProperty[0]);
            this.addSpanningChild(this.hotbar, new InventoryProperty[0]);
            this.addChild(new GridInventoryLensImpl(this.base, 9, 4, 9, slots), new InventoryProperty[0]);
        } else {
            this.hotbar = new HotbarLensImpl(base, 9, slots);
            this.grid = new GridInventoryLensImpl(base += 9, 9, 3, 9, slots);
            this.addSpanningChild(this.grid, new InventoryProperty[0]);
            this.addSpanningChild(this.hotbar, new InventoryProperty[0]);
            ShiftedSlotProvider shiftedSlots = new ShiftedSlotProvider(slots, 9, 36);
            this.addChild(new GridInventoryLensImpl(this.base, 9, 4, 9, (SlotProvider<IInventory, ItemStack>)shiftedSlots), new InventoryProperty[0]);
        }
        this.cache();
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots, boolean spanning) {
    }

    @Override
    public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> fabric, Inventory parent) {
        return new MainPlayerInventoryAdapter(fabric, this, parent);
    }

    @Override
    public HotbarLens<IInventory, ItemStack> getHotbar() {
        return this.hotbar;
    }

    @Override
    public GridInventoryLens<IInventory, ItemStack> getGrid() {
        return this.grid;
    }

    private class ShiftedSlotProvider
    implements SlotProvider<IInventory, ItemStack> {
        private final SlotProvider<IInventory, ItemStack> provider;
        private final int shiftBy;
        private final int shiftAt;

        public ShiftedSlotProvider(SlotProvider<IInventory, ItemStack> provider, int shiftBy, int shiftAt) {
            this.provider = provider;
            this.shiftBy = shiftBy;
            this.shiftAt = shiftAt;
        }

        @Override
        public SlotLens<IInventory, ItemStack> getSlot(int index) {
            if ((index += this.shiftBy) >= this.shiftAt) {
                index -= this.shiftAt;
            }
            return this.provider.getSlot(index);
        }
    }
}

