/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.custom;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.item.inventory.util.ContainerUtil;

public class CustomInventoryListener
implements EventListener<InteractInventoryEvent> {
    private Inventory inventory;
    List<Consumer<InteractInventoryEvent>> consumers;

    public CustomInventoryListener(Inventory inventory, List<Consumer<? extends InteractInventoryEvent>> consumers) {
        this.inventory = inventory;
        this.consumers = ImmutableList.copyOf(consumers);
    }

    @Override
    public void handle(InteractInventoryEvent event) throws Exception {
        Container nativeContainer = ContainerUtil.toNative(event.getTargetInventory());
        for (Slot slot : nativeContainer.field_75151_b) {
            if (slot.field_75224_c != this.inventory) continue;
            for (Consumer<InteractInventoryEvent> consumer : this.consumers) {
                consumer.accept(event);
            }
        }
    }
}

