/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

class TileEntityTickPhaseState
extends LocationBasedTickPhaseState<TileEntityTickContext> {
    TileEntityTickPhaseState() {
    }

    @Override
    public TileEntityTickContext createPhaseContext() {
        return (TileEntityTickContext)((TileEntityTickContext)new TileEntityTickContext().addEntityCaptures()).addBlockCaptures();
    }

    @Override
    Location<World> getLocationSourceFromContext(PhaseContext<?> context) {
        return context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).getLocation();
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).getLocatableBlock();
    }

    @Override
    public void unwind(TileEntityTickContext phaseContext) {
        TileEntity tickingTile = phaseContext.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", phaseContext));
        Optional<User> notifier = phaseContext.getNotifier();
        Optional<User> owner = phaseContext.getOwner();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
            Sponge.getCauseStackManager().pushCause(tickingTile.getLocatableBlock());
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.BLOCK_SPAWNING);
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), capturedEntities);
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception occured while processing tile entity %s at %s", tickingTile, tickingTile.getLocation()), e);
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, TileEntityTickContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.source(tickingTile);
    }

    @Override
    public boolean spawnEntityOrCapture(TileEntityTickContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        TileEntity tickingTile = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        Optional<User> notifier = context.getNotifier();
        Optional<User> owner = context.getOwner();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        IMixinTileEntity mixinTileEntity = (IMixinTileEntity)((Object)tickingTile);
        if (entity instanceof EntityXPOrb) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(tickingTile.getLocatableBlock());
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.EXPERIENCE);
                context.addNotifierAndOwnerToCauseStack();
                ArrayList<org.spongepowered.api.entity.Entity> exp = new ArrayList<org.spongepowered.api.entity.Entity>();
                exp.add(entity);
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), exp);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity anEntity : event.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
        ArrayList<org.spongepowered.api.entity.Entity> nonExpEntities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        nonExpEntities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(tickingTile.getLocatableBlock());
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, mixinTileEntity.getTickedSpawnType());
            context.addNotifierAndOwnerToCauseStack();
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), nonExpEntities);
            SpongeImpl.postEvent(spawnEntityEvent);
            if (!spawnEntityEvent.isCancelled()) {
                for (org.spongepowered.api.entity.Entity anEntity : spawnEntityEvent.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "TileEntityTickPhase";
    }
}

