/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;

public class PacketContext<P extends PacketContext<P>>
extends PhaseContext<P> {
    EntityPlayerMP packetPlayer;
    Packet<?> packet;
    private ItemStackSnapshot cursor;
    private boolean ignoreCreative;
    private ItemStack itemUsed;

    protected PacketContext(PacketState<? extends P> state) {
        super(state);
    }

    public P packet(Packet<?> packet) {
        this.packet = packet;
        return (P)this;
    }

    public P packetPlayer(EntityPlayerMP playerMP) {
        this.packetPlayer = playerMP;
        return (P)this;
    }

    public P cursor(ItemStackSnapshot snapshot) {
        this.cursor = snapshot;
        return (P)this;
    }

    public P ignoreCreative(boolean creative) {
        this.ignoreCreative = creative;
        return (P)this;
    }

    public EntityPlayerMP getPacketPlayer() {
        return this.packetPlayer;
    }

    public Player getSpongePlayer() {
        return (Player)this.packetPlayer;
    }

    public <K extends Packet<?>> K getPacket() {
        return (K)this.packet;
    }

    public ItemStackSnapshot getCursor() {
        return this.cursor;
    }

    public boolean getIgnoringCreative() {
        return this.ignoreCreative;
    }

    public P itemUsed(ItemStack stack) {
        this.itemUsed = stack;
        return (P)this;
    }

    public ItemStack getItemUsed() {
        return this.itemUsed;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer) {
        return super.printCustom(printer).add("    - %s: %s", "PacketPlayer", this.packetPlayer).add("    - %s: %s", "Packet", this.packet).add("    - %s: %s", "IgnoreCreative", this.ignoreCreative).add("    - %s: %s", "ItemStackUsed", this.itemUsed);
    }
}

