/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketUseEntity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class InteractEntityPacketState
extends BasicPacketState {
    InteractEntityPacketState() {
    }

    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }

    @Override
    public boolean isPacketIgnored(Packet<?> packetIn, EntityPlayerMP packetPlayer) {
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packetIn;
        Entity entity = useEntityPacket.func_149564_a(packetPlayer.field_70170_p);
        return entity == null;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        ItemStack stack;
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packet;
        Entity entity = useEntityPacket.func_149564_a(playerMP.field_70170_p);
        if (entity != null && (stack = ItemStackUtil.cloneDefensive(playerMP.func_184586_b(useEntityPacket.func_186994_b()))) != null) {
            context.itemUsed(stack);
        }
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean doesCaptureEntityDrops() {
        return true;
    }

    @Override
    public void unwind(BasicPacketContext phaseContext) {
        EntityPlayerMP player = phaseContext.getPacketPlayer();
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)phaseContext.getPacket();
        Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity == null) {
            return;
        }
        World spongeWorld = EntityUtil.getSpongeWorld((Entity)player);
        EntityUtil.toMixin(entity).setNotifier(player.func_110124_au());
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Interact Entity").centre().hr();
            printer.add("The blocks captured are:");
            for (BlockSnapshot blockSnapshot : blocks) {
                printer.add("  Block: %s", blockSnapshot);
            }
            printer.trace(System.err);
        });
        phaseContext.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Interact Entity").centre().hr();
            printer.add("The entities captured are:");
            for (org.spongepowered.api.entity.Entity capturedEntity : entities) {
                printer.add("  Entity: %s", capturedEntity);
            }
            printer.trace(System.err);
        });
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PLACEMENT);
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                List items = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), items);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    InteractEntityPacketState.processSpawnedEntities(player, event);
                }
            });
        }
        phaseContext.getCapturedEntityDropSupplier().acceptIfNotEmpty(map -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Interact Entity").centre().hr();
            printer.add("The item stacks captured are: ");
            for (Map.Entry entry : map.asMap().entrySet()) {
                printer.add("  - Entity with UUID: %s", entry.getKey());
                for (ItemDropData stack : (Collection)entry.getValue()) {
                    printer.add("    - %s", stack);
                }
            }
            printer.trace(System.err);
        });
        phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(snapshots -> TrackingUtil.processBlockCaptures(snapshots, this, phaseContext));
    }
}

