/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class DeathPhase
extends EntityPhaseState<BasicEntityContext> {
    DeathPhase() {
    }

    @Override
    public boolean tracksBlockSpecificDrops() {
        return true;
    }

    @Override
    public boolean tracksEntityDeaths() {
        return true;
    }

    @Override
    public BasicEntityContext createPhaseContext() {
        return (BasicEntityContext)((BasicEntityContext)new BasicEntityContext(this).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(BasicEntityContext context) {
        org.spongepowered.api.entity.Entity dyingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", context));
        DamageSource damageSource = context.getDamageSource();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(damageSource);
            Sponge.getCauseStackManager().pushCause(dyingEntity);
            boolean isPlayer = dyingEntity instanceof EntityPlayer;
            EntityPlayer entityPlayer = isPlayer ? (EntityPlayer)dyingEntity : null;
            Optional<User> notifier = context.getNotifier();
            Optional<User> owner = context.getOwner();
            User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
            context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
                List other;
                List experience = entities.stream().filter(entity -> entity instanceof ExperienceOrb).collect(Collectors.toList());
                if (!experience.isEmpty()) {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.EXPERIENCE);
                    SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), experience);
                    SpongeImpl.postEvent(spawnEntityEvent);
                    if (!spawnEntityEvent.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity entity2 : spawnEntityEvent.getEntities()) {
                            EntityUtil.getMixinWorld(entity2).forceSpawnEntity(entity2);
                        }
                    }
                }
                if (!(other = entities.stream().filter(entity -> !(entity instanceof ExperienceOrb)).collect(Collectors.toList())).isEmpty()) {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.ENTITY_DEATH);
                    SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), experience);
                    SpongeImpl.postEvent(spawnEntityEvent);
                    if (!spawnEntityEvent.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity entity3 : spawnEntityEvent.getEntities()) {
                            EntityUtil.getMixinWorld(entity3).forceSpawnEntity(entity3);
                        }
                    }
                }
            });
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            if (context.getCapturedEntityItemDropSupplier().isEmpty() && context.getCapturedEntityDropSupplier().isEmpty()) {
                ArrayList entities2 = new ArrayList();
                DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(frame.getCurrentCause(), entities2);
                SpongeImpl.postEvent(destruct);
                if (!destruct.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
                return;
            }
            context.getCapturedEntityItemDropSupplier().acceptAndRemoveIfPresent(dyingEntity.getUniqueId(), items -> {
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                if (isPlayer) {
                    entityPlayer.field_71071_by.func_174888_l();
                }
                DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(destruct);
                if (!destruct.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
            context.getCapturedEntityDropSupplier().acceptAndRemoveIfPresent(dyingEntity.getUniqueId(), itemStacks -> {
                ArrayList items = new ArrayList();
                items.addAll(itemStacks);
                if (!items.isEmpty()) {
                    Entity minecraftEntity = EntityUtil.toNative(dyingEntity);
                    List itemEntities = items.stream().map(data -> data.create((WorldServer)minecraftEntity.field_70170_p)).map(EntityUtil::fromNative).collect(Collectors.toList());
                    if (isPlayer) {
                        entityPlayer.field_71071_by.func_174888_l();
                    }
                    DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), itemEntities);
                    SpongeImpl.postEvent(destruct);
                    if (!destruct.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                            if (entityCreator != null) {
                                EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                            }
                            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                        }
                    }
                }
            });
        }
    }
}

