/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;

public class PlayerPhase
extends TrackingPhase {
    public static PlayerPhase getInstance() {
        return Holder.INSTANCE;
    }

    private PlayerPhase() {
    }

    public void unwind(IPhaseState<?> state, PhaseContext<?> phaseContext) {
        Player player = phaseContext.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing a player leaving, but we're not!", phaseContext));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
            phaseContext.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(dispense);
                if (!dispense.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : dispense.getEntities()) {
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            });
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            phaseContext.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(items -> {
                List drops = items.stream().map(drop -> drop.create(EntityUtil.getMinecraftWorld(player))).collect(Collectors.toList());
                List entities = drops;
                if (!entities.isEmpty()) {
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity droppedItem : event.getEntities()) {
                            EntityUtil.getMixinWorld(droppedItem).forceSpawnEntity(droppedItem);
                        }
                    }
                }
            });
            phaseContext.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, phaseContext));
        }
    }

    private static final class Holder {
        static final PlayerPhase INSTANCE = new PlayerPhase();

        private Holder() {
        }
    }

    static final class PlayerPhaseState
    implements IPhaseState<GeneralizedContext> {
        private final String className = this.getClass().getSimpleName();

        PlayerPhaseState() {
        }

        @Override
        public TrackingPhase getPhase() {
            return TrackingPhases.PLAYER;
        }

        @Override
        public GeneralizedContext createPhaseContext() {
            return new GeneralizedContext(this);
        }

        @Override
        public void unwind(GeneralizedContext phaseContext) {
        }

        public String toString() {
            return this.getPhase() + "{" + this.className + "}";
        }
    }

    public static final class State {
        public static final IPhaseState<GeneralizedContext> PLAYER_LOGOUT = new PlayerPhaseState();
    }
}

