/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.ThreadUtil;

@Singleton
public class SpongeCauseStackManager
implements CauseStackManager {
    public static final boolean DEBUG_CAUSE_FRAMES = Boolean.valueOf(System.getProperty("sponge.debugcauseframes", "false"));
    private final Deque<Object> cause = Queues.newArrayDeque();
    private final Deque<CauseStackFrameImpl> frames = Queues.newArrayDeque();
    private Map<EventContextKey<?>, Object> ctx = Maps.newHashMap();
    private int min_depth = 0;
    private Cause cached_cause;
    private EventContext cached_ctx;

    @Inject
    private SpongeCauseStackManager() {
    }

    private void enforceMainThread() {
        if (Sponge.isServerAvailable() && !SpongeCauseStackManager.isPermittedThread()) {
            throw new IllegalStateException(String.format("CauseStackManager called from off main thread (current='%s', expected='%s')!", ThreadUtil.getDescription(Thread.currentThread()), ThreadUtil.getDescription(SpongeImpl.getServer().func_175583_aK())));
        }
    }

    private static boolean isPermittedThread() {
        return Sponge.getServer().isMainThread() || Thread.currentThread().getName().equals("Server Shutdown Thread");
    }

    @Override
    public Cause getCurrentCause() {
        this.enforceMainThread();
        if (this.cached_cause == null || this.cached_ctx == null) {
            this.cached_cause = this.cause.isEmpty() ? Cause.of(this.getCurrentContext(), SpongeImpl.getGame()) : Cause.of(this.getCurrentContext(), this.cause);
        }
        return this.cached_cause;
    }

    @Override
    public EventContext getCurrentContext() {
        this.enforceMainThread();
        if (this.cached_ctx == null) {
            this.cached_ctx = EventContext.of(this.ctx);
        }
        return this.cached_ctx;
    }

    @Override
    public CauseStackManager pushCause(Object obj) {
        this.enforceMainThread();
        Preconditions.checkNotNull((Object)obj, (Object)"obj");
        this.cached_cause = null;
        this.cause.push(obj);
        return this;
    }

    @Override
    public Object popCause() {
        this.enforceMainThread();
        if (this.cause.size() <= this.min_depth) {
            throw new IllegalStateException("Cause stack corruption, tried to pop more objects off than were pushed since last frame (Size was " + this.cause.size() + " but mid depth is " + this.min_depth + ")");
        }
        this.cached_cause = null;
        return this.cause.pop();
    }

    @Override
    public void popCauses(int n) {
        this.enforceMainThread();
        for (int i = 0; i < n; ++i) {
            this.popCause();
        }
    }

    @Override
    public Object peekCause() {
        this.enforceMainThread();
        return this.cause.peek();
    }

    @Override
    public CauseStackManager.StackFrame pushCauseFrame() {
        this.enforceMainThread();
        CauseStackFrameImpl frame = new CauseStackFrameImpl(this.min_depth);
        this.frames.push(frame);
        this.min_depth = this.cause.size();
        if (DEBUG_CAUSE_FRAMES) {
            frame.stack_debug = new Exception();
        }
        return frame;
    }

    @Override
    public void popCauseFrame(CauseStackManager.StackFrame oldFrame) {
        this.enforceMainThread();
        Preconditions.checkNotNull((Object)oldFrame, (Object)"oldFrame");
        CauseStackFrameImpl frame = this.frames.peek();
        if (frame != oldFrame) {
            int offset = -1;
            int i = 0;
            for (CauseStackFrameImpl f : this.frames) {
                if (f == oldFrame) {
                    offset = i;
                    break;
                }
                ++i;
            }
            if (!DEBUG_CAUSE_FRAMES && offset == -1) {
                throw new IllegalStateException("Cause Stack Frame Corruption! Attempted to pop a frame that was not on the stack.");
            }
            PrettyPrinter prettyPrinter = new PrettyPrinter(100).add("Cause Stack Frame Corruption!").centre().hr().add("Found %d frames left on the stack. Clearing them all.", offset + 1);
            if (!DEBUG_CAUSE_FRAMES) {
                prettyPrinter.add().add("Please add -Dsponge.debugcauseframes=true to your startup flags to enable further debugging output.");
                SpongeImpl.getLogger().warn("  Add -Dsponge.debugcauseframes to your startup flags to enable further debugging output.");
            } else {
                prettyPrinter.add().add("Attempting to pop frame:").add(frame.stack_debug).add().add("Frames being popped are:").add(((CauseStackFrameImpl)oldFrame).stack_debug);
            }
            while (offset >= 0) {
                CauseStackFrameImpl f;
                f = this.frames.peek();
                if (DEBUG_CAUSE_FRAMES && offset > 0) {
                    prettyPrinter.add((Object)"   Stack frame in position %n:", offset);
                    prettyPrinter.add(f.stack_debug);
                }
                this.popCauseFrame(f);
                --offset;
            }
            prettyPrinter.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            if (offset == -1) {
                throw new IllegalStateException("Cause Stack Frame Corruption! Attempted to pop a frame that was not on the stack.");
            }
            return;
        }
        this.frames.pop();
        boolean ctx_invalid = false;
        if (frame.hasNew()) {
            for (EventContextKey eventContextKey : frame.getNew()) {
                this.ctx.remove(eventContextKey);
            }
            ctx_invalid = true;
        }
        if (frame.hasStoredValues()) {
            for (Map.Entry entry : frame.getStoredValues()) {
                this.ctx.put((EventContextKey<?>)entry.getKey(), entry.getValue());
            }
            ctx_invalid = true;
        }
        if (ctx_invalid) {
            this.cached_ctx = null;
        }
        while (this.cause.size() > this.min_depth) {
            this.cause.pop();
            this.cached_cause = null;
        }
        this.min_depth = frame.old_min_depth;
    }

    @Override
    public <T> CauseStackManager addContext(EventContextKey<T> key, T value) {
        this.enforceMainThread();
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(value, (Object)"value");
        this.cached_ctx = null;
        Object existing = this.ctx.put(key, value);
        if (!this.frames.isEmpty()) {
            CauseStackFrameImpl frame = this.frames.peek();
            if (existing == null) {
                frame.markNew(key);
            } else if (!frame.isNew(key) && !frame.isStored(key)) {
                frame.store(key, existing);
            }
        }
        return this;
    }

    @Override
    public <T> Optional<T> getContext(EventContextKey<T> key) {
        this.enforceMainThread();
        Preconditions.checkNotNull(key, (Object)"key");
        return Optional.ofNullable(this.ctx.get(key));
    }

    @Override
    public <T> Optional<T> removeContext(EventContextKey<T> key) {
        CauseStackFrameImpl frame;
        this.enforceMainThread();
        Preconditions.checkNotNull(key, (Object)"key");
        this.cached_ctx = null;
        Object existing = this.ctx.remove(key);
        if (existing != null && !this.frames.isEmpty() && !(frame = this.frames.peek()).isNew(key)) {
            frame.store(key, existing);
        }
        return Optional.ofNullable(existing);
    }

    public static class CauseStackFrameImpl
    implements CauseStackManager.StackFrame {
        @Nullable
        private Map<EventContextKey<?>, Object> stored_ctx_values;
        @Nullable
        private Set<EventContextKey<?>> new_ctx_values;
        public int old_min_depth;
        public Exception stack_debug = null;

        public CauseStackFrameImpl(int old_depth) {
            this.old_min_depth = old_depth;
        }

        public boolean isStored(EventContextKey<?> key) {
            return this.stored_ctx_values != null && this.stored_ctx_values.containsKey(key);
        }

        public Set<Map.Entry<EventContextKey<?>, Object>> getStoredValues() {
            return this.stored_ctx_values.entrySet();
        }

        public boolean hasStoredValues() {
            return this.stored_ctx_values != null && !this.stored_ctx_values.isEmpty();
        }

        public void store(EventContextKey<?> key, Object existing) {
            if (this.stored_ctx_values == null) {
                this.stored_ctx_values = new HashMap();
            }
            this.stored_ctx_values.put(key, existing);
        }

        public boolean isNew(EventContextKey<?> key) {
            return this.new_ctx_values != null && this.new_ctx_values.contains(key);
        }

        public Set<EventContextKey<?>> getNew() {
            return this.new_ctx_values;
        }

        public boolean hasNew() {
            return this.new_ctx_values != null && !this.new_ctx_values.isEmpty();
        }

        public void markNew(EventContextKey<?> key) {
            if (this.new_ctx_values == null) {
                this.new_ctx_values = new HashSet();
            }
            this.new_ctx_values.add(key);
        }

        @Override
        public Cause getCurrentCause() {
            return Sponge.getCauseStackManager().getCurrentCause();
        }

        @Override
        public EventContext getCurrentContext() {
            return Sponge.getCauseStackManager().getCurrentContext();
        }

        @Override
        public CauseStackManager.StackFrame pushCause(Object obj) {
            Sponge.getCauseStackManager().pushCause(obj);
            return this;
        }

        @Override
        public Object popCause() {
            return Sponge.getCauseStackManager().popCause();
        }

        @Override
        public <T> CauseStackManager.StackFrame addContext(EventContextKey<T> key, T value) {
            Sponge.getCauseStackManager().addContext(key, value);
            return this;
        }

        @Override
        public <T> Optional<T> removeContext(EventContextKey<T> key) {
            return Sponge.getCauseStackManager().removeContext(key);
        }

        @Override
        public void close() {
            Sponge.getCauseStackManager().popCauseFrame(this);
        }
    }
}

