/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableSkullData;
import org.spongepowered.api.data.manipulator.mutable.SkullData;
import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.SpongeSkullData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.processor.common.SkullUtils;
import org.spongepowered.common.data.type.SpongeSkullType;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class ItemSkullDataProcessor
extends AbstractItemSingleDataProcessor<SkullType, Value<SkullType>, SkullData, ImmutableSkullData> {
    public ItemSkullDataProcessor() {
        super(SkullUtils::supportsObject, Keys.SKULL_TYPE);
    }

    @Override
    protected Optional<SkullType> getVal(ItemStack itemStack) {
        return Optional.of(SkullUtils.getSkullType(itemStack));
    }

    @Override
    public Optional<SkullData> fill(DataContainer container, SkullData skullData) {
        return Optional.of(skullData.set(Keys.SKULL_TYPE, SpongeImpl.getGame().getRegistry().getType(SkullType.class, DataUtil.getData((DataView)container, Keys.SKULL_TYPE, String.class)).get()));
    }

    @Override
    protected boolean set(ItemStack itemStack, SkullType type) {
        itemStack.func_77964_b((int)((SpongeSkullType)type).getByteId());
        return true;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected Value<SkullType> constructValue(SkullType defaultValue) {
        return new SpongeValue<SkullType>(Keys.SKULL_TYPE, SkullTypes.SKELETON, defaultValue);
    }

    @Override
    protected ImmutableValue<SkullType> constructImmutableValue(SkullType value) {
        return ImmutableSpongeValue.cachedOf(Keys.SKULL_TYPE, SkullTypes.SKELETON, value);
    }

    @Override
    protected SkullData createManipulator() {
        return new SpongeSkullData();
    }
}

