/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableRespawnLocation;
import org.spongepowered.api.data.manipulator.mutable.entity.RespawnLocationData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableMapValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeRespawnLocationData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.entity.player.ISpongeUser;

public class RespawnLocationDataProcessor
extends AbstractSingleDataSingleTargetProcessor<User, Map<UUID, RespawnLocation>, MapValue<UUID, RespawnLocation>, RespawnLocationData, ImmutableRespawnLocation> {
    public RespawnLocationDataProcessor() {
        super(Keys.RESPAWN_LOCATIONS, User.class);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof ISpongeUser) {
            ImmutableMap<UUID, RespawnLocation> removed = ((ISpongeUser)((Object)container)).removeAllBeds();
            if (!removed.isEmpty()) {
                return DataTransactionResult.successRemove(this.constructImmutableValue((Map<UUID, RespawnLocation>)removed));
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean set(User user, Map<UUID, RespawnLocation> value) {
        if (user instanceof ISpongeUser) {
            return ((ISpongeUser)((Object)user)).setBedLocations(value);
        }
        return false;
    }

    @Override
    protected Optional<Map<UUID, RespawnLocation>> getVal(User user) {
        if (user instanceof ISpongeUser) {
            return Optional.of(((ISpongeUser)((Object)user)).getBedlocations());
        }
        return Optional.empty();
    }

    @Override
    protected MapValue<UUID, RespawnLocation> constructValue(Map<UUID, RespawnLocation> actualValue) {
        return new SpongeMapValue<UUID, RespawnLocation>(Keys.RESPAWN_LOCATIONS, actualValue);
    }

    protected ImmutableMapValue<UUID, RespawnLocation> constructImmutableValue(Map<UUID, RespawnLocation> value) {
        return new ImmutableSpongeMapValue<UUID, RespawnLocation>(Keys.RESPAWN_LOCATIONS, value);
    }

    @Override
    protected RespawnLocationData createManipulator() {
        return new SpongeRespawnLocationData();
    }
}

