/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableInvisibilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvisibilityData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeInvisibilityData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeInvisibilityData
extends AbstractData<InvisibilityData, ImmutableInvisibilityData>
implements InvisibilityData {
    private boolean vanish;
    private boolean collision;
    private boolean untargetable;
    private boolean invisible;

    public SpongeInvisibilityData() {
        this(false, false, false, false);
    }

    public SpongeInvisibilityData(boolean vanish, boolean collision, boolean untargetable, boolean invisible) {
        super(InvisibilityData.class);
        this.vanish = vanish;
        this.collision = collision;
        this.untargetable = untargetable;
        this.invisible = invisible;
    }

    @Override
    public Value<Boolean> invisible() {
        return new SpongeValue<Boolean>(Keys.INVISIBLE, false, this.invisible);
    }

    @Override
    public Value<Boolean> vanish() {
        return new SpongeValue<Boolean>(Keys.VANISH, false, this.vanish);
    }

    @Override
    public Value<Boolean> ignoresCollisionDetection() {
        return new SpongeValue<Boolean>(Keys.VANISH_IGNORES_COLLISION, false, this.collision);
    }

    @Override
    public Value<Boolean> untargetable() {
        return new SpongeValue<Boolean>(Keys.VANISH_PREVENTS_TARGETING, false, this.untargetable);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.VANISH, this::isVanish);
        this.registerFieldSetter(Keys.VANISH, value -> {
            this.vanish = value;
        });
        this.registerKeyValue(Keys.VANISH, this::vanish);
        this.registerFieldGetter(Keys.VANISH_IGNORES_COLLISION, this::isCollision);
        this.registerKeyValue(Keys.VANISH_IGNORES_COLLISION, this::ignoresCollisionDetection);
        this.registerFieldGetter(Keys.VANISH_PREVENTS_TARGETING, this::isUntargetable);
        this.registerKeyValue(Keys.VANISH_PREVENTS_TARGETING, this::untargetable);
        this.registerFieldGetter(Keys.INVISIBLE, () -> this.invisible);
        this.registerFieldSetter(Keys.INVISIBLE, value -> {
            this.invisible = value;
        });
        this.registerKeyValue(Keys.INVISIBLE, this::invisible);
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.INVISIBLE, (Object)this.invisible).set(Keys.VANISH, (Object)this.vanish).set(Keys.VANISH_IGNORES_COLLISION, (Object)this.collision).set(Keys.VANISH_PREVENTS_TARGETING, (Object)this.untargetable);
    }

    private boolean isVanish() {
        return this.vanish;
    }

    private boolean isCollision() {
        return this.collision;
    }

    private boolean isUntargetable() {
        return this.untargetable;
    }

    @Override
    public InvisibilityData copy() {
        return new SpongeInvisibilityData(this.vanish, this.collision, this.untargetable, this.invisible);
    }

    @Override
    public ImmutableInvisibilityData asImmutable() {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeInvisibilityData.class, this.vanish, this.collision, this.untargetable, this.invisible);
    }
}

