/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.advancement.SpongeAdvancementTree;
import org.spongepowered.common.interfaces.advancement.IMixinAdvancement;
import org.spongepowered.common.interfaces.advancement.IMixinDisplayInfo;

public class SpongeAdvancementTreeBuilder
implements AdvancementTree.Builder {
    private String id;
    @Nullable
    private String name;
    private Advancement rootAdvancement;
    private String background;

    public SpongeAdvancementTreeBuilder() {
        this.reset();
    }

    @Override
    public AdvancementTree.Builder rootAdvancement(Advancement rootAdvancement) {
        Preconditions.checkNotNull((Object)rootAdvancement, (Object)"rootAdvancement");
        Preconditions.checkState((boolean)((IMixinAdvancement)((Object)rootAdvancement)).isRegistered(), (Object)"The root advancement must be registered.");
        Preconditions.checkState((!rootAdvancement.getParent().isPresent() ? 1 : 0) != 0, (Object)"The root advancement cannot have a parent.");
        Preconditions.checkState((boolean)rootAdvancement.getDisplayInfo().isPresent(), (Object)"The root advancement must have display info.");
        Preconditions.checkState((((IMixinDisplayInfo)((Object)rootAdvancement.getDisplayInfo().get())).getBackground() == null ? 1 : 0) != 0, (Object)"The root advancement is already used by a different Advancement Tree.");
        this.rootAdvancement = rootAdvancement;
        return this;
    }

    @Override
    public AdvancementTree.Builder background(String background) {
        Preconditions.checkNotNull((Object)background, (Object)"background");
        this.background = background;
        return this;
    }

    @Override
    public AdvancementTree.Builder id(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.id = id;
        return this;
    }

    @Override
    public AdvancementTree.Builder name(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.name = name;
        return this;
    }

    @Override
    public AdvancementTree build() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"The id must be set");
        Preconditions.checkState((this.rootAdvancement != null ? 1 : 0) != 0, (Object)"The root advancement must be set");
        PluginContainer plugin = Sponge.getCauseStackManager().getCurrentCause().first(PluginContainer.class).get();
        String name = StringUtils.isEmpty((CharSequence)this.name) ? this.rootAdvancement.getDisplayInfo().map(DisplayInfo::getTitle).map(Text::toPlain).orElse(this.id) : this.name;
        SpongeAdvancementTree advancementTree = new SpongeAdvancementTree(this.rootAdvancement, plugin.getId() + ':' + this.id, name);
        ((IMixinDisplayInfo)((Object)this.rootAdvancement.getDisplayInfo().get())).setBackground(this.background);
        ((IMixinAdvancement)((Object)this.rootAdvancement)).setParent(null);
        SpongeAdvancementTreeBuilder.applyTree(this.rootAdvancement, advancementTree);
        return advancementTree;
    }

    private static void applyTree(Advancement advancement, AdvancementTree tree) {
        ((IMixinAdvancement)((Object)advancement)).setTree(tree);
        for (Advancement child : advancement.getChildren()) {
            SpongeAdvancementTreeBuilder.applyTree(child, tree);
        }
    }

    @Override
    public AdvancementTree.Builder reset() {
        this.background = "minecraft:textures/gui/advancements/backgrounds/stone.png";
        this.rootAdvancement = null;
        this.name = null;
        this.id = null;
        return this;
    }
}

