/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.game.state.GameStateEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.CustomDataConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.property.SpongePropertyRegistry;
import org.spongepowered.common.event.SpongeCauseStackManager;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.launch.SpongeLaunch;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.scheduler.SpongeScheduler;

@Singleton
public final class SpongeImpl {
    public static final String GAME_ID = "minecraft";
    public static final String GAME_NAME = "Minecraft";
    public static final String API_NAME = "SpongeAPI";
    public static final String ECOSYSTEM_ID = "sponge";
    public static final String ECOSYSTEM_NAME = "Sponge";
    public static final SpongeMinecraftVersion MINECRAFT_VERSION = new SpongeMinecraftVersion("1.12.2", 340);
    private static final Logger logger = LogManager.getLogger((String)"Sponge");
    public static final Random random = new Random();
    @Nullable
    private static SpongeConfig<GlobalConfig> globalConfig;
    @Nullable
    private static PluginContainer minecraftPlugin;
    @Nullable
    private static SpongeConfig<CustomDataConfig> customDataConfig;
    @Inject
    private static SpongeGame game;
    @Inject
    private static SpongeGameRegistry registry;
    @Inject
    private static SpongeDataManager dataManager;
    @Inject
    private static SpongePropertyRegistry propertyRegistry;
    @Inject
    private static SpongeScheduler scheduler;
    @Inject
    private static SpongeCauseStackManager causeStackManager;
    private static final List<PluginContainer> internalPlugins;

    private SpongeImpl() {
    }

    @Inject
    private static void initialize(Platform platform) {
        if (minecraftPlugin == null) {
            minecraftPlugin = platform.getContainer(Platform.Component.GAME);
        }
        for (Platform.Component component : Platform.Component.values()) {
            internalPlugins.add(platform.getContainer(component));
        }
    }

    private static <T> T check(@Nullable T instance) {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"SpongeImpl has not been initialized!");
        return instance;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static boolean isInitialized() {
        return game != null;
    }

    public static SpongeGame getGame() {
        return SpongeImpl.check(game);
    }

    public static MinecraftServer getServer() {
        return (MinecraftServer)Sponge.getServer();
    }

    public static DataFixer getDataFixer() {
        return ((IMixinMinecraftServer)((Object)Sponge.getServer())).getDataFixer();
    }

    public static SpongeGameRegistry getRegistry() {
        return SpongeImpl.check(registry);
    }

    public static SpongeDataManager getDataManager() {
        return SpongeImpl.check(dataManager);
    }

    public static SpongePropertyRegistry getPropertyRegistry() {
        return SpongeImpl.check(propertyRegistry);
    }

    public static SpongeScheduler getScheduler() {
        return SpongeImpl.check(scheduler);
    }

    public static SpongeCauseStackManager getCauseStackManager() {
        return SpongeImpl.check(causeStackManager);
    }

    public static PluginContainer getPlugin() {
        return Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION);
    }

    public static PluginContainer getMinecraftPlugin() {
        Preconditions.checkState((minecraftPlugin != null ? 1 : 0) != 0, (Object)"Minecraft plugin container is not initialized");
        return minecraftPlugin;
    }

    public static void setMinecraftPlugin(PluginContainer minecraft) {
        Preconditions.checkState((minecraftPlugin == null ? 1 : 0) != 0, (Object)"Minecraft plugin container is already initialized");
        minecraftPlugin = minecraft;
    }

    public static Path getGameDir() {
        return SpongeLaunch.getGameDir();
    }

    public static Path getPluginConfigDir() {
        return SpongeLaunch.getPluginConfigDir();
    }

    public static Path getPluginsDir() {
        return SpongeLaunch.getPluginsDir();
    }

    public static Path getSpongeConfigDir() {
        return SpongeLaunch.getSpongeConfigDir();
    }

    public static SpongeConfig<GlobalConfig> getGlobalConfig() {
        if (globalConfig == null) {
            globalConfig = new SpongeConfig(SpongeConfig.Type.GLOBAL, SpongeImpl.getSpongeConfigDir().resolve("global.conf"), ECOSYSTEM_ID);
        }
        return globalConfig;
    }

    public static SpongeConfig<CustomDataConfig> getDataConfig() {
        if (customDataConfig == null) {
            customDataConfig = new SpongeConfig(SpongeConfig.Type.CUSTOM_DATA, SpongeImpl.getSpongeConfigDir().resolve("custom_data.conf"), ECOSYSTEM_ID);
        }
        return customDataConfig;
    }

    public static List<PluginContainer> getInternalPlugins() {
        return internalPlugins;
    }

    public static boolean postEvent(Event event) {
        return Sponge.getEventManager().post(event);
    }

    public static boolean postEvent(Event event, boolean allowClient) {
        if (Sponge.getEventManager() instanceof SpongeEventManager) {
            return ((SpongeEventManager)Sponge.getEventManager()).post(event, allowClient);
        }
        return true;
    }

    public static void postState(GameState state, GameStateEvent event) {
        SpongeImpl.check(game);
        game.setState(state);
        SpongeImpl.postEvent(event, true);
    }

    public static void postShutdownEvents() {
        SpongeImpl.check(game);
        SpongeImpl.postState(GameState.GAME_STOPPING, SpongeEventFactory.createGameStoppingEvent(Sponge.getCauseStackManager().getCurrentCause()));
        SpongeImpl.postState(GameState.GAME_STOPPED, SpongeEventFactory.createGameStoppedEvent(Sponge.getCauseStackManager().getCurrentCause()));
    }

    public static PluginContainer getPluginContainer(Object plugin) throws IllegalArgumentException {
        Optional<PluginContainer> containerOptional = Sponge.getGame().getPluginManager().fromInstance(plugin);
        if (!containerOptional.isPresent()) {
            throw new IllegalArgumentException("The provided plugin object does not have an associated plugin container (in other words, is 'plugin' actually your plugin object?");
        }
        return containerOptional.get();
    }

    public static boolean isMainThread() {
        return !Sponge.isServerAvailable() || Sponge.getServer().isMainThread();
    }

    static {
        internalPlugins = new ArrayList<PluginContainer>();
    }
}

