/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.config.Config;
import exnihiloadscensio.items.ore.ItemOre;
import exnihiloadscensio.items.ore.Ore;
import exnihiloadscensio.json.CustomBlockInfoJson;
import exnihiloadscensio.json.CustomItemInfoJson;
import exnihiloadscensio.json.CustomOreJson;
import exnihiloadscensio.registries.manager.IOreDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.util.BlockInfo;
import exnihiloadscensio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class OreRegistry {
    private static List<Ore> registry = new ArrayList<Ore>();
    private static List<Ore> externalRegistry = new ArrayList<Ore>();
    private static HashSet<ItemOre> itemOreRegistry = new HashSet();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).registerTypeAdapter(Ore.class, (Object)new CustomOreJson()).create();

    public static void registerDefaults() {
        for (IOreDefaultRegistryProvider provider : RegistryManager.getDefaultOreRecipeHandlers()) {
            provider.registerOreRecipeDefaults();
        }
    }

    @Deprecated
    public static Ore registerOre(String name, Color color, ItemInfo info) {
        return OreRegistry.register(name, color, info);
    }

    public static Ore register(String name, Color color, ItemInfo info) {
        Ore ore = OreRegistry.registerInternal(name, color, info);
        externalRegistry.add(ore);
        return ore;
    }

    private static Ore registerInternal(String name, Color color, ItemInfo info) {
        Ore ore = new Ore(name, color, info);
        registry.add(ore);
        itemOreRegistry.add(new ItemOre(ore));
        return ore;
    }

    public static void registerFromRegistry() {
        for (Ore ore : registry) {
            itemOreRegistry.add(new ItemOre(ore));
        }
    }

    public static void doRecipes() {
        for (ItemOre ore : itemOreRegistry) {
            ItemStack smeltingResult;
            if (Config.shouldOreDictOreChunks) {
                OreDictionary.registerOre((String)("ore" + StringUtils.capitalize((String)ore.getOre().getName())), (ItemStack)new ItemStack((Item)ore, 1, 1));
            }
            if (Config.shouldOreDictOreDusts) {
                OreDictionary.registerOre((String)("dust" + StringUtils.capitalize((String)ore.getOre().getName())), (ItemStack)new ItemStack((Item)ore, 1, 2));
            }
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ore, 1, 1), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Item)ore, 1, 0)});
            if (ore.isRegisterIngot()) {
                smeltingResult = new ItemStack((Item)ore, 1, 3);
                OreDictionary.registerOre((String)("ingot" + StringUtils.capitalize((String)ore.getOre().getName())), (ItemStack)smeltingResult);
                if (ore.getOre().getName().contains("aluminium")) {
                    OreDictionary.registerOre((String)"ingotAluminum", (ItemStack)smeltingResult);
                }
            } else {
                smeltingResult = ore.getOre().getResult().getItemStack();
            }
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ore, 1, 1), smeltingResult, 0.7f);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)ore, 1, 2), smeltingResult, 0.7f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        ItemMeshDefinition ORES = new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                switch (stack.func_77952_i()) {
                    case 0: {
                        return new ModelResourceLocation("exnihiloadscensio:itemOre", "type=piece");
                    }
                    case 1: {
                        return new ModelResourceLocation("exnihiloadscensio:itemOre", "type=hunk");
                    }
                    case 2: {
                        return new ModelResourceLocation("exnihiloadscensio:itemOre", "type=dust");
                    }
                    case 3: {
                        return new ModelResourceLocation("exnihiloadscensio:itemOre", "type=ingot");
                    }
                }
                return new ModelResourceLocation(stack.func_77973_b().getRegistryName(), "inventory");
            }
        };
        for (ItemOre ore : itemOreRegistry) {
            ModelLoader.setCustomMeshDefinition((Item)ore, (ItemMeshDefinition)ORES);
            ModelBakery.registerItemVariants((Item)ore, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("exnihiloadscensio:itemOre", "type=piece"), new ModelResourceLocation("exnihiloadscensio:itemOre", "type=hunk"), new ModelResourceLocation("exnihiloadscensio:itemOre", "type=dust"), new ModelResourceLocation("exnihiloadscensio:itemOre", "type=ingot")});
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a((Item)ore, ORES);
        }
    }

    public static void loadJson(File file) {
        registry.clear();
        itemOreRegistry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                List gsonInput = (List)gson.fromJson((Reader)fr, new TypeToken<List<Ore>>(){}.getType());
                registry.addAll(gsonInput);
                OreRegistry.registerFromRegistry();
                registry.addAll(externalRegistry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            OreRegistry.registerDefaults();
            OreRegistry.saveJson(file);
        }
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashSet<ItemOre> getItemOreRegistry() {
        return itemOreRegistry;
    }
}

