/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.barrel.modes.block;

import exnihiloadscensio.barrel.IBarrelMode;
import exnihiloadscensio.barrel.modes.block.BarrelItemHandlerBlock;
import exnihiloadscensio.networking.MessageBarrelModeUpdate;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.tiles.TileBarrel;
import exnihiloadscensio.util.ItemInfo;
import exnihiloadscensio.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeBlock
implements IBarrelMode {
    private ItemInfo block;
    private BarrelItemHandlerBlock handler = new BarrelItemHandlerBlock(null);

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        if (this.block != null) {
            tag.func_74778_a("block", this.block.toString());
        }
        if (this.handler.getStackInSlot(0) != null) {
            this.handler.getStackInSlot(0).func_77955_b(tag);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("block")) {
            this.block = new ItemInfo(tag.func_74779_i("block"));
        }
        this.handler.setStackInSlot(0, ItemStack.func_77949_a((NBTTagCompound)tag));
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return false;
    }

    @Override
    public String getName() {
        return "block";
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        if (this.handler.getStackInSlot(0) != null) {
            currenttip.add(this.handler.getStackInSlot(0).func_82833_r());
        }
        return currenttip;
    }

    @Override
    public boolean onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.handler.getStackInSlot(0) != null) {
            Util.dropItemInWorld(barrel, player, this.handler.getStackInSlot(0), 0.02);
            this.handler.setBarrel(barrel);
            this.handler.setStackInSlot(0, null);
            barrel.setMode("null");
            PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("null", barrel.func_174877_v()), barrel);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        ItemStack stack = this.handler.getStackInSlot(0);
        if (stack == null || Block.func_149634_a((Item)stack.func_77973_b()) == null) {
            return Util.getTextureFromBlockState(null);
        }
        return Util.getTextureFromBlockState(Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77952_i()));
    }

    @Override
    public Color getColorForRender() {
        return Util.whiteColor;
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        return 1.0f;
    }

    @Override
    public void update(TileBarrel barrel) {
    }

    @Override
    public boolean addItem(ItemStack stack, TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        if (this.handler.getStackInSlot(0) == null) {
            this.handler.insertItem(0, stack, false);
            return true;
        }
        return false;
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        return this.handler;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return false;
    }

    public ItemInfo getBlock() {
        return this.block;
    }

    public void setBlock(ItemInfo block) {
        this.block = block;
    }
}

