/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.barrel;

import exnihiloadscensio.barrel.IBarrelMode;
import exnihiloadscensio.networking.MessageBarrelModeUpdate;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.BarrelModeRegistry;
import exnihiloadscensio.tiles.TileBarrel;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelItemHandler
extends ItemStackHandler {
    private TileBarrel barrel;

    public BarrelItemHandler(TileBarrel barrel) {
        super(1);
        this.barrel = barrel;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.barrel.getMode() != null && this.barrel.getMode().getHandler(this.barrel) != null) {
            return this.barrel.getMode().getHandler(this.barrel).getStackInSlot(slot);
        }
        return null;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        ArrayList<IBarrelMode> modes;
        if (this.barrel.getMode() != null && this.barrel.getMode().isTriggerItemStack(stack)) {
            this.barrel.getMode().addItem(stack, this.barrel);
            this.barrel.func_70296_d();
            IBlockState state = this.barrel.func_145831_w().func_180495_p(this.barrel.func_174877_v());
            this.barrel.func_145831_w().func_175656_a(this.barrel.func_174877_v(), state);
        } else if (this.barrel.getMode() != null && this.barrel.getMode().getHandler(this.barrel) != null) {
            this.barrel.getMode().getHandler(this.barrel).setStackInSlot(slot, stack);
        } else if (this.barrel.getMode() == null && (modes = BarrelModeRegistry.getModes(BarrelModeRegistry.TriggerType.ITEM)) != null) {
            for (IBarrelMode possibleMode : modes) {
                if (!possibleMode.isTriggerItemStack(stack)) continue;
                this.barrel.setMode(possibleMode.getName());
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate(this.barrel.getMode().getName(), this.barrel.func_174877_v()), this.barrel);
                this.barrel.getMode().addItem(stack, this.barrel);
                this.barrel.func_70296_d();
                IBlockState state = this.barrel.func_145831_w().func_180495_p(this.barrel.func_174877_v());
                this.barrel.func_145831_w().func_175656_a(this.barrel.func_174877_v(), state);
            }
        }
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.barrel.getMode() != null && this.barrel.getMode().getHandler(this.barrel) != null) {
            return this.barrel.getMode().getHandler(this.barrel).extractItem(slot, amount, simulate);
        }
        return null;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.barrel.getMode() == null) {
            ArrayList<IBarrelMode> modes = BarrelModeRegistry.getModes(BarrelModeRegistry.TriggerType.ITEM);
            if (modes == null) {
                return stack;
            }
            for (IBarrelMode possibleMode : modes) {
                if (!possibleMode.isTriggerItemStack(stack)) continue;
                if (!simulate) {
                    this.barrel.setMode(possibleMode.getName());
                    PacketHandler.sendToAllAround(new MessageBarrelModeUpdate(this.barrel.getMode().getName(), this.barrel.func_174877_v()), this.barrel);
                    this.barrel.getMode().addItem(stack, this.barrel);
                    this.barrel.func_70296_d();
                    IBlockState state = this.barrel.func_145831_w().func_180495_p(this.barrel.func_174877_v());
                    this.barrel.func_145831_w().func_175656_a(this.barrel.func_174877_v(), state);
                }
                ItemStack ret = stack.func_77946_l();
                --ret.field_77994_a;
                return ret;
            }
            return stack;
        }
        if (this.barrel.getMode().getHandler(this.barrel) != null) {
            return this.barrel.getMode().getHandler(this.barrel).insertItem(slot, stack, simulate);
        }
        return stack;
    }
}

